// ==UserScript==
// @name         Viper Downloader
// @version      2.0
// @description  Multi-host downloader
// @match        https://viper.to/*
// @match        https://vipergirls.to/*
// @match        https://planetviper.club/*
// @match        https://viperbb.rocks/*
// @match        https://viperkats.eu/*
// @match        https://viperohilia.art/*
// @match        https://viperproxy.org/*
// @match        https://vipervault.link/*
// @require      https://unpkg.com/file-saver@2.0.4/dist/FileSaver.min.js
// @require      https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.5/jszip.min.js
// @grant        GM_xmlhttpRequest
// @grant        GM_addStyle
// @grant        GM_download
// @grant        GM_setClipboard
// @connect      imx.to
// @connect      image.imx.to
// @connect      i.imx.to
// @connect      t.imx.to
// @connect      imagevenue.com
// @connect      img*.imagevenue.com
// @connect      cdno-data.imagevenue.com
// @connect      imgbox.com
// @connect      images.imgbox.com
// @connect      images*.imgbox.com
// @connect      thumbs.imgbox.com
// @connect      thumbs*.imgbox.com
// @connect      vipr.im
// @connect      image*.vipr.im
// @connect      i*.vipr.im
// @connect      imagebam.com
// @connect      images*.imagebam.com
// @connect      thumbs*.imagebam.com
// @connect      turboimagehost.com
// @connect      img*.turboimagehost.com
// @connect      up.*.turboimagehost.com
// @connect      turboimg.net
// @connect      pixhost.to
// @connect      img*.pixhost.to
// @connect      t*.pixhost.to
// @connect      pimpandhost.com
// @connect      filesor.com
// @connect      ist4-1.filesor.com
// @connect      ist*.filesor.com
// @run-at       document-end
// ==/UserScript==

(function () {
  'use strict';

  const JSZip = window.JSZip;
  const saveAs = window.saveAs || window.FileSaver && window.FileSaver.saveAs || function (blob, filename) {
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    setTimeout(function () { URL.revokeObjectURL(url); }, 100);
  };

  const CONFIG = {
    maxConcurrent: 45,
    requestTimeout: 13000,
    retryAttempts: 2,
    retryDelay: 500,
    batchDelay: 200,
    downloadTimeout: 45000,
    maxCacheSize: 500,
    cacheTTL: 86400000,
    cacheCleanupInterval: 3600000,
    maxFilenameLength: 210,
    zipConcurrent: 3,
    stallTimeout: 30000,
    minImageSize: 70656,
    PROGRESS_PERSIST: 1,
    COPY_TITLE_BUTTON: 1
  };

  const activeOperations = new Map();
  const resolutionCache = new Map();
  const zipOperations = new Map();
  let postIdCounter = 0;
  let mutationObserver = null;
  let bodyWaitObserver = null;
  let cacheCleanupIntervalId = null;
  let activeGalleryCleanup = null;
  let activeScanTimeout = null;
  let currentErrorNotification = null;

  window.isFF = typeof InstallTrigger !== 'undefined';

  const postProcessing = new Map();

  function setPostProcessing(basePostId, isProcessing) {
    postProcessing.set(basePostId, isProcessing);
  }

  function isPostProcessing(basePostId) {
    return postProcessing.get(basePostId) === true;
  }

  function getBasePostId(postId) {
    return postId.replace(/_(?:IMX|ImV|BOX|VPR|BAM|TRB|PIX|PMP)$/, '');
  }

    const STYLES = {

  /* ==========================================
     CONTAINER & MAIN BUTTON
     ========================================== */
    buttons: `
    .vgt-container {
      position: relative;
      display: inline-block;
      margin-left: 8px;
    }

    .resolver-btn {
      padding: 6px 12px;
      border-radius: 8px;
      cursor: pointer;
      font-weight: 700;
      font-size: 11px;
      transition: all 0.2s, border-left-width 0.3s;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
      position: relative;
      overflow: hidden;
      background: linear-gradient(135deg, #1e293b, #334155);
      color: #06b6d4;
      border-left-width: 2px;
      border-left-style: solid;
      border-top: 1px solid rgba(255,255,255,0.06);
      border-right: 1px solid rgba(255,255,255,0.06);
      border-bottom: 1px solid rgba(255,255,255,0.06);
    }

    .resolver-btn:hover {
      border-left-width: 8px;
    }

    .resolver-btn::before {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: linear-gradient(
        45deg,
        transparent,
        rgba(6, 182, 212, 0.15),
        rgba(139, 92, 246, 0.15),
        rgba(236, 72, 153, 0.15),
        transparent
      );
      animation: shimmerRainbow 4s infinite;
    }

    .resolver-btn[disabled]::before {
      animation: none;
      opacity: 0;
    }

    @keyframes shimmerRainbow {
      0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
      100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
    }

    .resolver-btn[disabled] {
      opacity: 0.85;
      cursor: wait;
    }

    .resolver-btn .arrow {
      transition: transform 0.2s;
      display: inline-block;
    }

    .resolver-btn.open .arrow {
      transform: rotate(180deg);
    }

    .resolver-btn.open {
      border-left-width: 8px;
    }

    .resolver-btn-imx { border-left-color: #ff6b00; }
    .resolver-btn-imx .arrow { color: #ff6b00; }

    .resolver-btn-pmp { border-left-color: #ec4899; }
    .resolver-btn-pmp .arrow { color: #ec4899; }

    .resolver-btn-bam { border-left-color: #3b82f6; }
    .resolver-btn-bam .arrow { color: #3b82f6; }

    .resolver-btn-box { border-left-color: #eb4646; }
    .resolver-btn-box .arrow { color: #eb4646; }

    .resolver-btn-trb { border-left-color: #10b981; }
    .resolver-btn-trb .arrow { color: #10b981; }

    .resolver-btn-pix { border-left-color: #f7ed31; }
    .resolver-btn-pix .arrow { color: #f7ed31; }

    .resolver-btn-vpr { border-left-color: #7c3aed; }
    .resolver-btn-vpr .arrow { color: #7c3aed; }

    .resolver-btn-imv { border-left-color: #c67483; }
    .resolver-btn-imv .arrow { color: #c67483; }
  `,

  /* ==========================================
     LOADING SPINNERS & ANIMATIONS
     ========================================== */
  spinners: `
    .spinner-resolving {
      width: 16px;
      height: 16px;
      position: relative;
    }

    .spinner-resolving span {
      position: absolute;
      width: 2px;
      height: 2px;
      border-radius: 50%;
      background: #06b6d4;
      top: 50%;
      left: 50%;
      margin: -1px 0 0 -1px;
      animation: flash 1.6s ease-in-out infinite;
    }

    .spinner-resolving span:nth-child(1) { transform: rotate(0deg) translateX(7px); animation-delay: 0s; }
    .spinner-resolving span:nth-child(2) { transform: rotate(30deg) translateX(7px); animation-delay: 0.1s; }
    .spinner-resolving span:nth-child(3) { transform: rotate(60deg) translateX(7px); animation-delay: 0.2s; }
    .spinner-resolving span:nth-child(4) { transform: rotate(90deg) translateX(7px); animation-delay: 0.3s; }
    .spinner-resolving span:nth-child(5) { transform: rotate(120deg) translateX(7px); animation-delay: 0.4s; }
    .spinner-resolving span:nth-child(6) { transform: rotate(150deg) translateX(7px); animation-delay: 0.5s; }
    .spinner-resolving span:nth-child(7) { transform: rotate(180deg) translateX(7px); animation-delay: 0.6s; }
    .spinner-resolving span:nth-child(8) { transform: rotate(210deg) translateX(7px); animation-delay: 0.7s; }
    .spinner-resolving span:nth-child(9) { transform: rotate(240deg) translateX(7px); animation-delay: 0.8s; }
    .spinner-resolving span:nth-child(10) { transform: rotate(270deg) translateX(7px); animation-delay: 0.9s; }
    .spinner-resolving span:nth-child(11) { transform: rotate(300deg) translateX(7px); animation-delay: 1.0s; }
    .spinner-resolving span:nth-child(12) { transform: rotate(330deg) translateX(7px); animation-delay: 1.1s; }

    @keyframes flash {
      0%, 100% { opacity: 0.2; }
      8% { opacity: 1; }
      16% { opacity: 0.2; }
    }

    .spinner-downloading {
      width: 16px;
      height: 18px;
      position: relative;
      overflow: hidden;
    }

    .spinner-downloading span {
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
      width: 0;
      height: 0;
      border-left: 4px solid transparent;
      border-right: 4px solid transparent;
      border-top: 5px solid;
      animation: matrixFall 1s linear infinite;
    }

    .spinner-downloading span:nth-child(1) { border-top-color: #06b6d4; animation-delay: 0s; }
    .spinner-downloading span:nth-child(2) { border-top-color: #8b5cf6; animation-delay: 0.33s; }
    .spinner-downloading span:nth-child(3) { border-top-color: #ec4899; animation-delay: 0.66s; }

    @keyframes matrixFall {
      0% { top: -10px; opacity: 1; }
      100% { top: 20px; opacity: 0; }
    }
  `,

  /* ==========================================
     DROPDOWN MENU
     ========================================== */
  dropdown: `
    .vgt-dropdown {
      position: absolute;
      top: calc(100% + 6px);
      right: 0;
      background: #16181d;
      border: 2px solid;
      border-image: linear-gradient(135deg, #06b6d4, #8b5cf6) 1;
      border-radius: 8px;
      padding: 8px;
      min-width: 180px;
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.4);
      opacity: 0;
      transform: translateY(-10px);
      pointer-events: none;
      transition: opacity 0.2s, transform 0.2s;
      z-index: 1000;
    }

    .vgt-dropdown.open {
      opacity: 1;
      transform: translateY(0);
      pointer-events: all;
    }

    .vgt-dropdown-item {
      width: 100%;
      padding: 8px 12px;
      background: transparent;
      color: #9ca3af;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 11px;
      font-weight: 600;
      transition: all 0.2s;
      text-align: left;
      display: flex;
      align-items: center;
      gap: 8px;
      border-left: 3px solid transparent;
      position: relative;
    }

    .vgt-dropdown-item:hover {
      background: rgba(6, 182, 212, 0.1);
      color: #06b6d4;
      border-left-color: #06b6d4;
    }

    .vgt-dropdown-item:not(:last-child)::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 50%;
      transform: translateX(-50%);
      width: 70%;
      height: 1px;
      background: linear-gradient(to right, transparent, rgba(6, 182, 212, 0.3), transparent);
    }

    .icon-svg {
      width: 13px;
      height: 13px;
      flex-shrink: 0;
      transition: all 0.2s;
    }

    .vgt-dropdown-item:hover .icon-svg {
      filter: drop-shadow(0 0 4px currentColor);
    }

    .vgt-dropdown-item:nth-child(1) .icon-svg {
      color: #ef4444;
    }

    .vgt-dropdown-item:nth-child(2) .icon-svg {
      color: #f59e0b;
    }

    .vgt-dropdown-item:nth-child(3) .icon-svg {
      color: #06b6d4;
    }

    .vgt-dropdown-item:nth-child(4) .icon-svg {
      color: #3b82f6;
    }
  `,

  /* ==========================================
     CANCEL BUTTON
     ========================================== */
  cancelButton: `
    .resolver-btn-cancel {
      padding: 4px 8px;
      background: rgba(239, 68, 68, 0.1);
      border: 1px solid rgba(239, 68, 68, 0.3);
      border-radius: 4px;
      color: #fca5a5;
      font-size: 10px;
      font-weight: 600;
      cursor: pointer;
      backdrop-filter: blur(10px);
      transition: all 0.2s;
      white-space: nowrap;
      margin-left: 8px;
    }

    .resolver-btn-cancel:hover {
      background: rgba(239, 68, 68, 0.2);
      border-color: rgba(239, 68, 68, 0.5);
      color: #fff;
    }
  `,

  /* ==========================================
     PROGRESS BARS
     ========================================== */
  progress: `
    .vgt-progress {
      background: rgba(255, 255, 255, 0.05);
      border: 1px solid rgba(255, 255, 255, 0.1);
      border-radius: 8px;
      padding: 20px;
      margin-top: 12px;
      display: none;
    }

    .vgt-progress.active {
      display: block;
    }

    .vgt-progress-row {
      display: grid;
      grid-template-columns: 50px 1fr 50px;
      gap: 10px;
      align-items: center;
      margin-bottom: 12px;
    }

    .vgt-progress-row:last-of-type {
      margin-bottom: 0;
    }

    .vgt-progress-label {
      font-size: 11px;
      color: #9ca3af;
      font-weight: 600;
    }

    .vgt-progress-bar-container {
      height: 6px;
      border-radius: 8px;
      background: #2a2a2a;
      overflow: hidden;
      position: relative;
    }

    .vgt-progress-bar-fill {
      height: 100%;
      background: linear-gradient(90deg, #3b82f6, #8b5cf6);
      border-radius: 8px;
      position: relative;
      box-shadow: 0 0 20px rgba(6, 182, 212, 0.8);
      transition: width 0.3s ease;
      width: 0%;
    }

    .vgt-progress-bar-fill::after {
      content: '';
      position: absolute;
      right: -4px;
      top: 50%;
      transform: translateY(-50%);
      width: 10px;
      height: 10px;
      border-radius: 50%;
      background: #06b6d4;
      box-shadow:
        0 0 12px #06b6d4,
        0 0 20px rgba(6, 182, 212, 0.9),
        0 0 30px rgba(6, 182, 212, 0.7);
    }

    @keyframes glowPulse {
      0%, 100% {
        box-shadow:
          0 0 12px #06b6d4,
          0 0 20px rgba(6, 182, 212, 0.9),
          0 0 30px rgba(6, 182, 212, 0.7);
      }
      50% {
        box-shadow:
          0 0 16px #06b6d4,
          0 0 28px rgba(6, 182, 212, 1),
          0 0 40px rgba(6, 182, 212, 0.8);
      }
    }

    .vgt-progress.active .vgt-progress-bar-fill::after {
      animation: glowPulse 1.5s ease-in-out infinite;
    }

    .vgt-progress-percent-container {
      display: flex;
      flex-direction: column;
      align-items: flex-end;
      gap: 4px;
    }

    .vgt-progress-percent {
      font-size: 11px;
      color: #06b6d4;
      font-weight: 700;
    }

    .vgt-progress-footer {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-top: 8px;
    }

    .vgt-progress-status {
      flex: 1;
      text-align: center;
      font-size: 13px;
      font-weight: 700;
      color: #9ca3af;
      transition: color 0.2s;
    }

    .vgt-progress-status.resolving {
      color: #06b6d4;
    }

    .vgt-progress-status.downloading {
      color: #3b82f6;
    }

    .vgt-progress-status.compressing {
      color: #8b5cf6;
    }

    .vgt-progress-status.complete {
      color: #10b981;
    }

    .vgt-progress-status.error {
      color: #ef4444;
    }
  `,

  /* ==========================================
     STATUS PILLS & WAVE ANIMATION
     ========================================== */
  pills: `
    .bracket-flash {
      display: inline-block;
      margin-right: 6px;
    }

    .b1-wave {
      display: inline-block;
      animation: waveFlash 0.9s infinite;
    }

    .b2-wave {
      display: inline-block;
      animation: waveFlash 0.9s infinite 0.3s;
    }

    .b3-wave {
      display: inline-block;
      animation: waveFlash 0.9s infinite 0.6s;
    }

    @keyframes waveFlash {
      0% { opacity: 0.2; transform: scale(1); }
      50% { opacity: 1; transform: scale(1.2); }
      100% { opacity: 0.2; transform: scale(1); }
    }

    .pill {
      display: inline-block;
      padding: 3px 10px;
      border-radius: 12px;
      font-size: 10px;
      margin-left: 8px;
      font-weight: 600;
      border: 1px solid;
    }

    .pill.green {
      background: linear-gradient(135deg, rgba(16, 185, 129, 0.2), rgba(6, 182, 212, 0.2));
      border-color: rgba(16, 185, 129, 0.4);
      color: #10b981;
    }

    .pill.yellow {
      background: linear-gradient(135deg, rgba(251, 191, 36, 0.2), rgba(249, 115, 22, 0.2));
      border-color: rgba(251, 191, 36, 0.4);
      color: #fbbf24;
    }

    .pill.red {
      background: linear-gradient(135deg, rgba(239, 68, 68, 0.2), rgba(244, 63, 94, 0.2));
      border-color: rgba(239, 68, 68, 0.4);
      color: #fca5a5;
    }
  `,

  /* ==========================================
     MODAL / GALLERY OVERLAY
     ========================================== */
  modal: `
    .vgt-overlay {
      position: fixed;
      inset: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      background: rgba(0, 0, 0, 0.85);
      z-index: 2147483646;
      padding: 16px;
      opacity: 0;
      pointer-events: none;
      transition: opacity 0.2s;
    }

    .vgt-overlay.open {
      opacity: 1;
      pointer-events: all;
    }

    .vgt-modal {
      width: 100%;
      max-width: 1200px;
      max-height: 92vh;
      overflow: auto;
      background: rgba(31, 41, 55, 0.95);
      backdrop-filter: blur(20px);
      color: #e5e7eb;
      border: 3px solid #4a5568;
      border-radius: 8px;
      padding: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.7);
      font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial;
      transform: scale(0.95);
      transition: transform 0.3s;
    }

    .vgt-overlay.open .vgt-modal {
      transform: scale(1);
    }

    .vgt-header {
      display: flex;
      justify-content: center;
      align-items: center;
      gap: 12px;
      margin-bottom: 20px;
      padding-bottom: 12px;
      border-bottom: 2px solid;
      border-image: linear-gradient(to right, transparent, rgba(6, 182, 212, 0.3), transparent) 1;
    }

    .vgt-title {
      font-weight: 700;
      font-size: 18px;
      color: #06b6d4;
      text-align: center;
    }

    .resolver-btn-close {
      position: fixed;
      right: 18px;
      bottom: 18px;
      background: rgba(239, 68, 68, 0.2);
      border: 2px solid rgba(239, 68, 68, 0.5);
      backdrop-filter: blur(10px);
      color: #fff;
      width: 120px;
      height: 120px;
      border-radius: 50%;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 800;
      font-size: 48px;
      box-shadow: 0 10px 30px rgba(239, 68, 68, 0.3);
      z-index: 2147483650;
      transition: all 0.2s;
    }

    .resolver-btn-close:hover {
      background: rgba(239, 68, 68, 0.3);
      border-color: rgba(239, 68, 68, 0.7);
      transform: scale(1.05);
      box-shadow: 0 0 20px rgba(239, 68, 68, 0.5);
    }
  `,

  /* ==========================================
     GALLERY GRID & ITEMS
     ========================================== */
  gallery: `
    .vgt-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 12px;
    }

    @media(max-width: 1200px) {
      .vgt-grid {
        grid-template-columns: repeat(3, 1fr);
      }
    }

    @media(max-width: 768px) {
      .vgt-grid {
        grid-template-columns: repeat(2, 1fr);
      }
    }

    .vgt-grid-item {
      border: 1px solid rgba(255, 255, 255, 0.06);
      border-radius: 8px;
      overflow: hidden;
      display: flex;
      flex-direction: column;
    }

    .vgt-thumb {
      width: 100%;
      height: 170px;
      object-fit: contain;
      display: block;
      cursor: pointer;
    }

    .vgt-actions {
      display: flex;
      gap: 6px;
      padding: 8px;
    }

    .resolver-btn-download {
      flex: 1;
      padding: 8px;
      border-radius: 6px;
      background: transparent;
      border: 2px solid #06b6d4;
      color: #06b6d4;
      font-size: 11px;
      font-weight: 700;
      cursor: pointer;
      transition: none;
      position: relative;
    }

    .resolver-btn-download.downloaded {
      border-color: #10b981;
      color: #10b981;
    }

    .dl-text {
      opacity: 1;
      transition: opacity 0.3s ease;
    }

    .dl-icon {
      opacity: 0;
      position: absolute;
      left: 50%;
      top: 50%;
      transform: translate(-50%, -50%);
      transition: opacity 0.3s ease;
    }

    .resolver-btn-failed {
      flex: 1;
      padding: 8px;
      border-radius: 6px;
      background: transparent;
      border: 2px solid #ef4444;
      color: #ef4444;
      font-size: 11px;
      font-weight: 700;
      cursor: default;
      opacity: 0.7;
    }

    .resolver-btn-download.success-pulse {
      animation: vgtSuccessPulse 2s ease;
    }

    @keyframes vgtSuccessPulse {
      0% { box-shadow: 0 0 0 0 rgba(16, 185, 129, 0.7); }
      50% { box-shadow: 0 0 0 8px rgba(16, 185, 129, 0); }
      100% { box-shadow: 0 0 0 0 rgba(16, 185, 129, 0); }
    }
  `,

    /* ==========================================
     NOTIFICATIONS / TOASTS
     ========================================== */
  notifications: `
    .vgt-notice {
      position: fixed;
      top: 12px;
      right: 12px;
      background: #ef4444;
      color: #fff;
      padding: 10px 14px;
      border-radius: 8px;
      z-index: 2147483647;
      box-shadow: 0 8px 30px rgba(0, 0, 0, 0.25);
    }

    .vgt-notice.success {
      background: #10b981;
    }

    .vgt-error-notification {
      position: fixed;
      top: 80px;
      right: 20px;
      background: rgba(22, 24, 29, 0.98);
      backdrop-filter: blur(20px);
      color: #e5e7eb;
      padding: 20px;
      border-radius: 12px;
      border: 1px solid rgba(239, 68, 68, 0.4);
      z-index: 2147483647;
      box-shadow:
        0 25px 50px rgba(0, 0, 0, 0.5),
        0 0 40px rgba(239, 68, 68, 0.15),
        inset 0 1px 0 rgba(255, 255, 255, 0.05);
      max-width: 480px;
      min-width: 320px;
      max-height: 400px;
      font-family: system-ui, -apple-system, "Segoe UI", Roboto, Arial;
      animation: vgtErrorSlideIn 0.25s ease-out;
    }

    @keyframes vgtErrorSlideIn {
      from {
        opacity: 0;
        transform: translateX(20px);
      }
      to {
        opacity: 1;
        transform: translateX(0);
      }
    }

    .vgt-error-notification .error-title {
      font-weight: 700;
      font-size: 13px;
      color: #fca5a5;
      margin-bottom: 14px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      gap: 12px;
    }

    .vgt-error-notification .error-title span {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .vgt-error-notification .error-content {
      font-size: 11px;
      line-height: 1.7;
      white-space: pre-wrap;
      word-break: break-all;
      overflow-wrap: break-word;
      background: rgba(0, 0, 0, 0.4);
      padding: 14px;
      border-radius: 8px;
      max-height: 280px;
      overflow-y: auto;
      color: #9ca3af;
      border: 1px solid rgba(255, 255, 255, 0.04);
      font-family: ui-monospace, SFMono-Regular, "SF Mono", Consolas, monospace;
    }

    .vgt-error-notification .error-content::-webkit-scrollbar {
      width: 6px;
    }

    .vgt-error-notification .error-content::-webkit-scrollbar-track {
      background: rgba(0, 0, 0, 0.2);
      border-radius: 3px;
    }

    .vgt-error-notification .error-content::-webkit-scrollbar-thumb {
      background: rgba(239, 68, 68, 0.3);
      border-radius: 3px;
    }

    .vgt-error-notification .error-content::-webkit-scrollbar-thumb:hover {
      background: rgba(239, 68, 68, 0.5);
    }

    .vgt-error-notification .error-close-btn {
      background: transparent;
      color: #6b7280;
      border: 1px solid rgba(107, 114, 128, 0.3);
      border-radius: 6px;
      width: 26px;
      height: 26px;
      font-size: 12px;
      font-weight: 600;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 0;
      transition: all 0.15s ease;
      flex-shrink: 0;
    }

     .vgt-error-notification .error-close-btn:hover {
      background: rgba(239, 68, 68, 0.15);
      border-color: rgba(239, 68, 68, 0.4);
      color: #fca5a5;
    }
  `,

  titleCopyButton: `
    .viper-copy-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 34px;
      height: 34px;
      padding: 0;
      margin-left: 12px;
      background: #1e293b;
      color: #06b6d4;
      border: none;
      border-radius: 10px;
      cursor: pointer;
      box-shadow:
        8px 8px 16px rgba(0, 0, 0, 0.4),
        -8px -8px 16px rgba(255, 255, 255, 0.05);
      transition: all 200ms cubic-bezier(0.4, 0, 0.2, 1);
      flex-shrink: 0;
      position: relative;
      vertical-align: middle;
    }

    .viper-copy-btn::before {
      content: '';
      position: absolute;
      inset: 0;
      background: transparent;
      border-radius: inherit;
      pointer-events: none;
    }

    .viper-copy-btn:hover {
      background: #1e293b;
      color: #22d3ee;
      box-shadow:
        inset 4px 4px 8px rgba(0, 0, 0, 0.4),
        inset -4px -4px 8px rgba(255, 255, 255, 0.05);
    }

    .viper-copy-btn:active {
      box-shadow:
        inset 6px 6px 12px rgba(0, 0, 0, 0.5),
        inset -6px -6px 12px rgba(255, 255, 255, 0.03);
    }

    .viper-copy-btn--success {
      background: linear-gradient(145deg, #22c55e, #16a34a) !important;
      box-shadow: 0 2px 12px rgba(34, 197, 94, 0.4) !important;
    }

    .viper-copy-btn--success svg {
      color: #ffffff !important;
      stroke: #ffffff !important;
    }

    .viper-copy-btn svg {
      transition: transform 200ms ease;
    }

    .viper-copy-btn:hover svg {
      transform: scale(1.1);
    }

    .viper-copy-btn--animate {
      animation: viper-pop 400ms cubic-bezier(0.68, -0.55, 0.265, 1.55);
    }

    @keyframes viper-pop {
      0% { transform: scale(1); }
      50% { transform: scale(1.15); }
      100% { transform: scale(1); }
    }

    .viper-copy-btn[data-tooltip] {
      position: relative;
    }

    .viper-copy-btn[data-tooltip]::after {
      content: attr(data-tooltip);
      position: absolute;
      bottom: calc(100% + 8px);
      left: 50%;
      transform: translateX(-50%) scale(0.8);
      padding: 6px 10px;
      background: rgba(0, 0, 0, 0.85);
      color: white;
      font-size: 12px;
      font-weight: 500;
      white-space: nowrap;
      border-radius: 6px;
      opacity: 0;
      visibility: hidden;
      transition: all 200ms ease;
      pointer-events: none;
      z-index: 1000;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
    }

    .viper-copy-btn[data-tooltip]:hover::after {
      opacity: 1;
      visibility: visible;
      transform: translateX(-50%) scale(1);
    }

    .p-title-value {
      display: inline !important;
    }
  `
};

    function injectStyles() {
  GM_addStyle(Object.values(STYLES).join('\n'));
}

  function fixProtocol(url) {
    if (!url) return url;
    if (url.startsWith('//')) return 'https:' + url;
    if (url.startsWith('http:')) return url.replace('http:', 'https:');
    return url;
  }

  function sleep(ms) {
    return new Promise(function (r) { setTimeout(r, ms); });
  }

    function showNotice(msg, timeout, isSuccess) {
    if (typeof timeout === 'undefined') timeout = 3000;
    if (!document.body) {
      console.warn('[Unified]', msg);
      return;
    }
    const n = document.createElement('div');
    n.className = 'vgt-notice' + (isSuccess ? ' success' : '');
    n.textContent = msg;
    document.body.appendChild(n);
        setTimeout(function () {
      try { n.remove(); } catch (e) { console.error('[Unified] notice removal error:', e); }
    }, timeout);
  }

  function showErrorNotification(message, failedLinks) {
    if (typeof failedLinks === 'undefined') failedLinks = [];
    if (!document.body) {
      console.warn('[Unified] Error:', message, failedLinks);
      return null;
    }

    if (currentErrorNotification && currentErrorNotification.parentElement) {
      const errorContent = currentErrorNotification.querySelector('.error-content');
      const titleSpan = currentErrorNotification.querySelector('.error-title span');
      if (titleSpan) titleSpan.textContent = '⚠ ' + message;
      if (errorContent && failedLinks.length > 0) {
        const existingText = errorContent.textContent;
        const numberedLinks = failedLinks.map(function(link, idx) {
          return (idx + 1) + '. ' + link;
        }).join('\n\n');
        errorContent.textContent = existingText + (existingText ? '\n\n' : '') + numberedLinks;
      }
      return currentErrorNotification;
    }

    const notification = document.createElement('div');
    notification.className = 'vgt-error-notification';

    const titleDiv = document.createElement('div');
    titleDiv.className = 'error-title';

    const titleSpan = document.createElement('span');
    titleSpan.textContent = '⚠ ' + message;

    const closeBtn = document.createElement('button');
    closeBtn.className = 'error-close-btn';
    closeBtn.title = 'Close';
    closeBtn.textContent = '✕';

    closeBtn.addEventListener('click', function() {
      notification.style.opacity = '0';
      notification.style.transform = 'translateX(20px)';
      notification.style.transition = 'opacity 0.2s, transform 0.2s';
      setTimeout(function() {
        try {
          if (notification.parentElement) notification.remove();
          if (currentErrorNotification === notification) currentErrorNotification = null;
        } catch (e) { console.error('[Unified] error notification removal:', e); }
      }, 200);
    });

    titleDiv.appendChild(titleSpan);
    titleDiv.appendChild(closeBtn);
    notification.appendChild(titleDiv);

    if (failedLinks.length > 0) {
      const errorContent = document.createElement('div');
      errorContent.className = 'error-content';
      const numberedLinks = failedLinks.map(function(link, idx) {
        return (idx + 1) + '. ' + link;
      }).join('\n\n');
      errorContent.textContent = numberedLinks;
      notification.appendChild(errorContent);
    }

    document.body.appendChild(notification);
    currentErrorNotification = notification;
    return notification;
  }

  function dismissErrorNotification() {
    if (currentErrorNotification && currentErrorNotification.parentElement) {
      try {
        currentErrorNotification.remove();
      } catch (e) { console.error('[Unified] error notification dismiss:', e); }
      currentErrorNotification = null;
    }
  }

  async function copyToClipboard(text) {
    try {
      await GM_setClipboard(text);
      return true;
    } catch (err) {
      showNotice('Clipboard access failed', 3000);
      return false;
    }
  }

    function getThreadTitle() {
    const selectors = [
      'h1.p-title-value',
      '.p-title .p-title-value',
      'h1.thread-title',
      '.p-title > h1',
      'h1'
    ];

    for (let i = 0; i < selectors.length; i++) {
      const el = document.querySelector(selectors[i]);
      if (el) {
        return el.textContent
          .trim()
          .replace(/^Thread:\s*/i, '')
          .replace(/\s*[-|]\s*Viper.*$/i, '')
          .trim();
      }
    }

    return document.title
      .replace(/\s*[-|]\s*Viper.*$/i, '')
      .replace(/\s*[-|][^-|]*$/, '')
      .trim() || 'Download';
  }

  function stripExtAndLower(s) {
    if (!s) return '';
    return String(s).split('?')[0].replace(/\.(jpg|jpeg|png|gif|webp)$/i, '').toLowerCase();
  }

    function normalizeImxForKey(u) {
    if (!u) return '';
    try {
      const parsed = new URL(u);
      const host = parsed.hostname.toLowerCase();
      let pathname = parsed.pathname || '/';
      if (host === 't.imx.to' && pathname.startsWith('/t/')) {
        pathname = pathname.replace(/^\/t\//, '/i/');
      } else if (host === 'imx.to' && pathname.startsWith('/t/')) {
        pathname = pathname.replace(/^\/t\//, '/i/');
      } else if (host === 'image.imx.to' && pathname.includes('/u/t/')) {
        pathname = pathname.replace('/u/t/', '/u/i/');
      } else if (host === 'imx.to' && pathname.startsWith('/upload/')) {
        pathname = pathname.replace(/\/upload\/(?:small|medium|large)\//, '/u/i/');
      }
      const parts = pathname.split('/');
      const base = (parts.pop() || parts.pop() || '').split('?')[0];
      return stripExtAndLower(base);
    } catch (e) {
      return stripExtAndLower(String(u).split('/').pop());
    }
  }

  async function withRetry(fn, abortSignal, maxAttempts) {
    if (typeof maxAttempts === 'undefined') maxAttempts = CONFIG.retryAttempts;
    let lastError;
    for (let attempt = 0; attempt <= maxAttempts; attempt++) {
      if (abortSignal && abortSignal.aborted) throw new Error('Cancelled');
      try {
        return await fn();
      } catch (err) {
        lastError = err;
        if (attempt < maxAttempts) {
          await new Promise(r => setTimeout(r, CONFIG.retryDelay * Math.pow(2, attempt)));
          if (abortSignal && abortSignal.aborted) throw new Error('Cancelled');
        }
      }
    }
    throw lastError;
  }

      function isSafeUrl(url) {
    if (!url || typeof url !== 'string') return false;
    if (/^(javascript|data|vbscript|file|blob|about|chrome):/i.test(url)) return false;
    try {
      const parsed = new URL(url);
      return ['http:', 'https:'].includes(parsed.protocol) && parsed.hostname && parsed.hostname.length > 0;
    } catch (e) {
      return false;
    }
  }

  function safeAppendToBody(element) {
    if (!document.body || !element || !(element instanceof Node)) return false;
    document.body.appendChild(element);
    return true;
  }

  function getContentType(headers) {
    if (!headers || typeof headers !== 'string') return null;
    try {
      const lines = headers.toLowerCase().split(/[\r\n]+/);
      for (const line of lines) {
        if (line.startsWith('content-type:')) {
          return line.substring(13).split(';')[0].trim();
        }
      }
    } catch (e) { console.error('[Unified] getContentType error:', e); }
    return null;
  }

    function isValidImageContentType(headers) {
    const validTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/jpg'];
    const ctype = getContentType(headers);
    return ctype && validTypes.indexOf(ctype) !== -1;
  }

  function createDownloadBlob(response, headers) {
    const SAFE_IMAGE_TYPES = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/jpg'];
    const ctype = getContentType(headers);
    if (!ctype || !SAFE_IMAGE_TYPES.includes(ctype)) {
      return { error: 'Invalid content type' };
    }
    const blob = new Blob([response], { type: ctype });
    return { blob, blobUrl: URL.createObjectURL(blob) };
  }

  function addToCache(key, value) {
    if (resolutionCache.size >= CONFIG.maxCacheSize) {
      const firstKey = resolutionCache.keys().next().value;
      resolutionCache.delete(firstKey);
    }
    resolutionCache.set(key, { value, timestamp: Date.now() });
  }

  function getFromCache(key) {
    if (!resolutionCache.has(key)) return null;
    const cached = resolutionCache.get(key);
    if (Date.now() - cached.timestamp > CONFIG.cacheTTL) {
      resolutionCache.delete(key);
      return null;
    }
    return cached.value;
  }

    function cleanExpiredCache() {
    const now = Date.now();
    for (const [key, cached] of resolutionCache.entries()) {
      if (now - cached.timestamp > CONFIG.cacheTTL) resolutionCache.delete(key);
    }
  }

  function sanitizeWinSegment(seg, fallback) {
    if (typeof fallback === 'undefined') fallback = 'file';
    let s = String(seg == null ? '' : seg).trim();
    const sub = '-';
    s = s
      .replace(/[\u0000-\u001f\u007f]/g, '')
      .replace(/[<>:"/\\|?*]/g, sub)
      .replace(/\s+/g, ' ')
      .trim()
      .replace(/[. ]+$/g, '');

    if (!s) s = String(fallback || 'file');
    if (/^(con|prn|aux|nul|com[1-9]|lpt[1-9])$/i.test(s)) s = '_' + s;
    if (s.length > CONFIG.maxFilenameLength) s = s.slice(0, CONFIG.maxFilenameLength).trim();
    return s;
  }

  function sanitizeWinPath(p) {
    const parts = String(p == null ? '' : p)
      .split('/')
      .map(x => sanitizeWinSegment(x, ''))
      .filter(Boolean);
    return parts.join('/');
  }

    function getSafeZipName() {
    let title = getThreadTitle();
    title = sanitizeWinSegment(title);
    return title || 'Download';
  }

  function extractPostNumber(post) {
    const counterElement = post.querySelector('.postcounter');
    if (counterElement) {
      const text = counterElement.textContent.trim();
      return text.replace('#', '');
    }
    return post.id.replace('post_', '');
  }

  function getPostIndex(post) {
    const allPosts = document.querySelectorAll('li.postbitlegacy');
    return String(Array.from(allPosts).indexOf(post) + 1);
  }

        function extractImxLinks(post) {
    const results = [];
    try {
      const anchors = post.querySelectorAll('a[href*="imx.to"], a[href*="image.imx.to"], a[href*="i.imx.to"]');
      anchors.forEach(function (a) {
        try {
          const href = a.href;
          if (!href) return;
          const imgs = a.querySelectorAll('img');
          let thumb = '';
          if (imgs && imgs.length) thumb = imgs[0].src || '';
          results.push({ pageUrl: href, thumbUrl: thumb || href, uniqueId: (href.split('/').pop() || '') });
        } catch (e) { console.error('[Unified] extractImxLinks anchor error:', e); }
      });
      const imgs = post.querySelectorAll('img[src*="imx.to"], img[src*="image.imx.to"], img[src*="i.imx.to"]');
      imgs.forEach(function (img) {
        try {
          const src = img.src;
          if (!src) return;
          results.push({ pageUrl: src, thumbUrl: src, uniqueId: (src.split('/').pop() || '') });
        } catch (e) { console.error('[Unified] extractImxLinks img error:', e); }
      });
    } catch (e) { console.error('[Unified] extractImxLinks error:', e); }
    const seen = new Set();
    return results.filter(function (item) {
      const key = (item.pageUrl || '') + '|' + (item.thumbUrl || '');
      if (seen.has(key)) return false;
      seen.add(key);
      return true;
    });
  }

  function extractImagevenueLinks(post) {
    const seen = new Map();
    try {
        const anchors = post.querySelectorAll(
            'a[href*="imagevenue.com/img.php"],' +
            'a[href*="imagevenue.com/image/"],' +
            'a[href*="imagevenue.com/view/"],' +
            'a[href*="imagevenue.com/ME"]'
        );
        anchors.forEach(a => {
            try {
                const href = a.href;
                if (!href) return;
                let thumb = '';
                const img = a.querySelector('img');
                if (img && img.src) thumb = img.src;
                const uniqueId = href.split('image=').pop() || href.split('/').pop() || '';
                const key = thumb || href;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: href,
                        thumbUrl: thumb,
                        uniqueId: uniqueId
                    });
                } else {
                    const existing = seen.get(key);
                    if (existing && !existing.pageUrl && href) {
                        existing.pageUrl = href;
                    }
                }
            } catch (err) {
                console.error('[Unified] extractImagevenueLinks anchor error:', err);
            }
        });

        const imgs = post.querySelectorAll('img[src*="imagevenue.com"]');
        imgs.forEach(img => {
            try {
                const src = img.src;
                if (!src) return;
                const key = src;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: '',
                        thumbUrl: src,
                        uniqueId: src.split('/').pop() || ''
                    });
                }
            } catch (e) {
                console.error('[Unified] extractImagevenueLinks img error:', e);
            }
        });
    } catch (e) {
        console.error('[Unified] extractImagevenueLinks error:', e);
    }
    return Array.from(seen.values());
}

    function dedupePairsCanonical(pairs) {
    const map = new Map();
    const orderedKeys = [];
    pairs.forEach(function (p, idx) {
      const rawUnique = p.uniqueId || '';
      const u = p.pageUrl || p.thumbUrl || '';
      const key = (p.thumbUrl ? normalizeImxForKey(p.thumbUrl) : (rawUnique ? stripExtAndLower(rawUnique) : normalizeImxForKey(u) || String(idx))) || String(idx);
      if (!map.has(key)) {
        orderedKeys.push(key);
        map.set(key, { thumbUrl: p.thumbUrl || null, pageUrl: p.pageUrl || null, uniqueId: rawUnique || null, order: idx });
      } else {
        const ex = map.get(key);
        if (!ex.thumbUrl && p.thumbUrl) ex.thumbUrl = p.thumbUrl;
        if (!ex.pageUrl && p.pageUrl) ex.pageUrl = p.pageUrl;
        if (!ex.uniqueId && rawUnique) ex.uniqueId = rawUnique;
      }
    });
    return orderedKeys.map(function (k) {
      const v = map.get(k);
      return { thumbUrl: v.thumbUrl, pageUrl: v.pageUrl, uniqueId: v.uniqueId, order: v.order };
    });
  }

    function resolveImxLinkAdapter(url, abortSignal) {
    if (!url) return Promise.reject(new Error('No URL'));
    if (abortSignal && abortSignal.aborted) return Promise.reject(new Error('Cancelled'));
    try {
      let candidate = url;
      try {
        const parsed = new URL(candidate);
        const host = parsed.hostname.toLowerCase();
        if (host === 't.imx.to') {
          parsed.hostname = 'image.imx.to';
          parsed.pathname = '/u/i' + parsed.pathname.slice(2);
          candidate = parsed.toString();
        } else if (host === 'image.imx.to' && parsed.pathname.includes('/u/t/')) {
          parsed.pathname = parsed.pathname.replace('/u/t/', '/u/i/');
          candidate = parsed.toString();
        } else if (host === 'imx.to' && parsed.pathname.startsWith('/t/')) {
          parsed.hostname = 'i.imx.to';
          parsed.pathname = parsed.pathname.replace(/^\/t\//, '/i/');
          candidate = parsed.toString();
        } else if (host === 'imx.to' && parsed.pathname.match(/^\/upload\/(small|medium|large)\//)) {
          parsed.hostname = 'image.imx.to';
          parsed.pathname = parsed.pathname.replace(/^\/upload\/(?:small|medium|large)\//, '/u/i/');
          candidate = parsed.toString();
        } else if (host === 'imx.to' && parsed.pathname.startsWith('/upload/')) {
          parsed.hostname = 'image.imx.to';
          parsed.pathname = parsed.pathname.replace(/^\/upload\//, '/u/i/');
          candidate = parsed.toString();
        }
      } catch (e) { console.error('[Unified] resolveImxLinkAdapter parse error:', e); }
      candidate = fixProtocol(candidate);
      return Promise.resolve(candidate);
    } catch (err) {
      return Promise.reject(err);
    }
  }

    const shortImxRegex = /^https?:\/\/(?:i\.)?imx\.to\/i\/[A-Za-z0-9]+\/?$/i;
  const imgPageRegex = /^https?:\/\/(?:www\.)?imx\.to\/img-[A-Za-z0-9]+\.html$/i;

    function chooseResolveCandidate(p) {
    const page = p.pageUrl || '';
    const thumb = p.thumbUrl || '';
    if (page && (shortImxRegex.test(page) || imgPageRegex.test(page)) && thumb) return thumb;
    return page || thumb;
  }

    async function resolveAllImx(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for (let idx = 0; idx < pairs.length; idx++) {
      const p = pairs[idx];
      const candidate = p.resolveUrl || p.pageUrl || p.thumbUrl || '';

      const cached = getFromCache(candidate);
      if (cached !== null) {
        results.push(Object.assign({}, p, { fullUrl: cached, error: null }));
      } else {
        uncachedPairs.push(p);
      }
    }

    if (progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');
      const batch = batches[b];
      const promises = batch.map(function (p) {
        const cand = p.resolveUrl || p.pageUrl || p.thumbUrl || '';
        return resolveImxLinkAdapter(cand, signal)
          .then(function (full) {
            addToCache(cand, full);
            return Object.assign({}, p, { fullUrl: full, error: null });
          })
          .catch(function (err) {
            return Object.assign({}, p, { fullUrl: null, error: err.message });
          });
      });
      const res = await Promise.all(promises);
      results.push.apply(results, res);
      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

    return results;
  }

  function resolveUrl(src, baseUrl) {
    if (!src) return '';
    if (/^https?:\/\//i.test(src)) return src;
    if (src.startsWith('//')) return 'https:' + src;
    try {
      return baseUrl ? new URL(src, baseUrl).href : '';
    } catch (e) {
      return '';
    }
  }

  function getImgSrc(el, baseUrl) {
    if (!el) return '';
    const raw = el.getAttribute('src');
    return raw ? resolveUrl(raw, baseUrl) : '';
  }

  function isImageUrl(url) {
    if (!url) return false;
    return /\.(jpg|jpeg|png|gif|webp)$/i.test(String(url).split('?')[0]);
  }

   function resolveImagevenueLink(pageUrl, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
        if (abortSignal && abortSignal.aborted) return reject(new Error('Cancelled'));
        if (!pageUrl) return reject(new Error('No page URL'));

        const abortHandler = () => { try { req.abort(); } catch(e) { console.error('[Unified] abort error:', e); } };
        const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e) {} };

        const req = GM_xmlhttpRequest({
            method: 'GET',
            url: pageUrl,
            headers: {
                'Accept': 'text/html',
                'User-Agent': 'Mozilla/5.0',
                'Referer': 'https://www.imagevenue.com/'
            },
            timeout: CONFIG.requestTimeout,
            onload(res) {
                cleanup();
                if (abortSignal && abortSignal.aborted) return reject(new Error('Cancelled'));
                if (res.status !== 200) return reject(new Error('HTTP ' + res.status));
                try {
                    const doc = new DOMParser().parseFromString(res.responseText, 'text/html');
                    const baseUrl = res.finalUrl || pageUrl;
                    let imageUrl = null;
                    const mainImage = doc.getElementById('main-image');
                    if (mainImage) {
                        const src = getImgSrc(mainImage, baseUrl);
                        if (src && src.includes('imagevenue.com') && isImageUrl(src)) imageUrl = src;
                    }
                    if (!imageUrl) {
                        const thePic = doc.getElementById('thepic');
                        if (thePic) {
                            const src = getImgSrc(thePic, baseUrl);
                            if (src && src.includes('imagevenue.com') && isImageUrl(src)) imageUrl = src;
                        }
                    }
                    if (!imageUrl) {
                        for (const img of doc.querySelectorAll('img[src*="cdno-data.imagevenue.com"]')) {
                            const src = getImgSrc(img, baseUrl);
                            if (src && src.includes('cdno-data.imagevenue.com') && isImageUrl(src)) {
                                imageUrl = src;
                                break;
                            }
                        }
                    }
                    if (!imageUrl) {
                        const ogImage = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
                        if (ogImage) {
                            const content = ogImage.getAttribute('content');
                            if (content && content.includes('imagevenue.com') && isImageUrl(content)) {
                                imageUrl = resolveUrl(content, baseUrl);
                            }
                        }
                    }
                    if (!imageUrl) {
                        for (const im of doc.querySelectorAll('img[src*="imagevenue.com"]')) {
                            const src = getImgSrc(im, baseUrl);
                            if (!src) continue;
                            const lower = src.toLowerCase();
                            if (lower.includes('thumb') || lower.includes('_thumb') ||
                                lower.includes('_small') || lower.includes('/th_') ||
                                lower.includes('/tn_')) continue;
                            if (isImageUrl(src)) {
                                imageUrl = src;
                                break;
                            }
                        }
                    }
                    if (!imageUrl && doc.body) {
                        const text = (doc.body.textContent || '').substring(0, 50000);
                        const match = text.match(/(https?:\/\/cdno-data\.imagevenue\.com\/[^\s"'<>]{1,500}\.(?:jpg|jpeg|png|gif|webp))/i);
                        if (match) imageUrl = match[1];
                    }
                    if (imageUrl) {
                        const fixedUrl = imageUrl.startsWith('//') ? 'https:' + imageUrl : imageUrl;
                        if (!isSafeUrl(fixedUrl)) return reject(new Error('Unsafe URL detected'));
                        resolve(fixedUrl);
                    } else {
                        reject(new Error('No image URL found'));
                    }
                } catch (err) {
                    reject(err);
                }
            },
            onerror() { cleanup(); reject(new Error('Network error')); },
            ontimeout() { cleanup(); reject(new Error('Timeout')); }
        });
        if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
}

    async function resolveAllImagevenue(pairs, progressCallback, abortSignal) {
    const signal = abortSignal || { aborted: false };

    const results = [];
    const uncachedPairs = [];

    for (const p of pairs) {
      const cached = getFromCache(p.pageUrl);
      if (cached !== null) {
        results.push({ ...p, fullUrl: cached, error: null });
      } else {
        uncachedPairs.push(p);
      }
    }

    if (progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const promises = batches[b].map(p =>
        resolveImagevenueLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: err.message }))
      );

      results.push(...await Promise.all(promises));
      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1) await sleep(CONFIG.batchDelay);
    }

    return results;
  }

  function extractIboxLinks(post) {
    const links = [];
    const seen = new Map();

    try {
      const anchors = post.querySelectorAll('a[href*="imgbox.com"], a[href*="imagebox"], a[href*="imgbox"]');
      anchors.forEach(a => {
        try {
          const href = a.href;
          if (!href) return;

          let thumb = '';
          const img = a.querySelector('img');
          if (img && img.src) thumb = img.src;

          if (isImageUrl(href)) {
            const key = thumb || href;
            if (!seen.has(key)) {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: thumb || href,
                fullUrl: href,
                uniqueId: href.split('/').pop() || ''
              });
            }
          } else {
            const key = thumb || href;
            if (!seen.has(key)) {
              seen.set(key, {
                pageUrl: href,
                thumbUrl: thumb,
                fullUrl: null,
                uniqueId: href.split('/').pop() || ''
              });
            } else {
              const existing = seen.get(key);
              if (existing && !existing.pageUrl && href) {
                existing.pageUrl = href;
              }
            }
          }
        } catch (err) {}
      });

      const imgs = post.querySelectorAll('img[src*="imgbox.com"], img[src*="imagebox"], img[src*="imgbox"]');
      imgs.forEach(img => {
        try {
          const src = img.src;
          if (!src) return;

          const key = src;
          if (!seen.has(key)) {
            if (isImageUrl(src)) {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: src,
                fullUrl: src,
                uniqueId: src.split('/').pop() || ''
              });
            } else {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: src,
                fullUrl: null,
                uniqueId: src.split('/').pop() || ''
              });
            }
          }
        } catch (e) {}
      });
    } catch (e) {}

    return Array.from(seen.values());
  }

    function resolveIboxLink(pageUrl, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
      if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
      if (!pageUrl) { reject(new Error('No page URL to resolve')); return; }

      const abortHandler = () => { try { if(req) req.abort(); } catch(e){} };
      const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e){} };

      let req;
      try {
        req = GM_xmlhttpRequest({
          method: 'GET',
          url: pageUrl,
          headers: { 'Accept': 'text/html', 'User-Agent': 'Mozilla/5.0' },
          timeout: CONFIG.requestTimeout,
          onload(res) {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }

            if (res.status !== 200) {
              reject(new Error(`HTTP ${res.status}`));
              return;
            }

            try {
              const parser = new DOMParser();
              const doc = parser.parseFromString(res.responseText, 'text/html');
              let imageUrl = null;

              const og = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
              if (og) {
                const c = og.getAttribute('content');
                if (c && c.toLowerCase().includes('imgbox') && isImageUrl(c)) imageUrl = c;
              }

              if (!imageUrl) {
                const ids = ['image', 'img', 'picture', 'photo', 'show_image', 'main-image', 'fullimage'];
                for (const id of ids) {
                  const el = doc.getElementById(id);
                  if (el) {
                    if (el.tagName && el.tagName.toLowerCase() === 'img' && el.src && el.src.includes('imgbox')) {
                      if (isImageUrl(el.src)) { imageUrl = el.src; break; }
                    } else {
                      const imgInside = el.querySelector && el.querySelector('img[src*="imgbox"]');
                      if (imgInside && imgInside.src && isImageUrl(imgInside.src)) { imageUrl = imgInside.src; break; }
                    }
                  }
                }
              }

              if (!imageUrl) {
                const containers = doc.querySelectorAll('[id*="image"], [id*="img"], [class*="image"], [class*="img"], [class*="photo"], [class*="viewer"]');
                for (const c of containers) {
                  const img = c.querySelector && c.querySelector('img[src*="imgbox"]');
                  if (img && img.src && isImageUrl(img.src)) { imageUrl = img.src; break; }
                }
              }

              if (!imageUrl) {
                const imgs = doc.querySelectorAll('img[src*="imgbox"], img[src*="imagebox"]');
                for (const im of imgs) {
                  try {
                    const src = im.src;
                    if (!src) continue;
                    const lower = src.toLowerCase();
                    if (lower.includes('thumb') || lower.includes('_thumb') || lower.includes('_small') || lower.includes('/thumbs/')) continue;
                    if (isImageUrl(src)) { imageUrl = src; break; }
                  } catch (e) {}
                }
              }

              if (!imageUrl) {
                const anchors = doc.querySelectorAll('a[href*="imgbox"], a[href*="imagebox"]');
                for (const a of anchors) {
                  try {
                    const href = a.href;
                    if (!href) continue;
                    if (isImageUrl(href) && href.toLowerCase().includes('imgbox')) { imageUrl = href; break; }
                  } catch (e) {}
                }
              }

              if (imageUrl) resolve(fixProtocol(imageUrl));
              else reject(new Error('No image URL found'));
            } catch (err) { reject(err); }
          },
          onerror() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Network error'));
          },
          ontimeout() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Timeout'));
          }
        });
      } catch (err) {
        cleanup();
        reject(err);
      }

      if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
  }

  async function resolveAllIbox(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for(const p of pairs){
      if (p.fullUrl) {
        results.push({ ...p, error: null });
        continue;
      }

      const url = p.pageUrl;
      const cachedUrl = url ? getFromCache(url) : null;
      if(cachedUrl){
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else if (url) {
        uncachedPairs.push(p);
      } else {
        results.push({ ...p, fullUrl: null, error: 'No page URL' });
      }
    }

    if(progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p =>
        resolveIboxLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: err.message }))
      );

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

    return results;
  }

  // ==========================================
  // VIPR FUNCTIONS
  // ==========================================

  function extractViprLinks(post) {
    const seen = new Map();

    try {
      const anchors = post.querySelectorAll('a[href*="vipr.im"], a[href*="vipr."]');
      anchors.forEach(a => {
        try {
          const href = a.href;
          if (!href) return;

          let thumb = '';
          const img = a.querySelector('img');
          if (img && img.src) thumb = img.src;

          if (isImageUrl(href)) {
            const key = thumb || href;
            if (!seen.has(key)) {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: thumb || href,
                fullUrl: href,
                uniqueId: href.split('/').pop().split('?')[0] || ''
              });
            }
          } else {
            const key = thumb || href;
            if (!seen.has(key)) {
              seen.set(key, {
                pageUrl: href,
                thumbUrl: thumb,
                fullUrl: null,
                uniqueId: href.split('/').pop().split('?')[0] || ''
              });
            } else {
              const existing = seen.get(key);
              if (existing && !existing.pageUrl && href) {
                existing.pageUrl = href;
              }
            }
          }
        } catch (err) {}
      });

      const imgs = post.querySelectorAll('img[src*="vipr.im"], img[src*="vipr."]');
      imgs.forEach(img => {
        try {
          const src = img.src;
          if (!src) return;

          const key = src;
          if (!seen.has(key)) {
            if (isImageUrl(src)) {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: src,
                fullUrl: src,
                uniqueId: src.split('/').pop().split('?')[0] || ''
              });
            } else {
              seen.set(key, {
                pageUrl: '',
                thumbUrl: src,
                fullUrl: null,
                uniqueId: src.split('/').pop().split('?')[0] || ''
              });
            }
          }
        } catch (e) {}
      });
    } catch (e) {}

    return Array.from(seen.values());
  }

    function resolveViprLink(pageUrl, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
      if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
      if (!pageUrl) { reject(new Error('No page URL to resolve')); return; }

      const abortHandler = () => { try { if(req) req.abort(); } catch(e){} };
      const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e){} };

      let req;
      try {
        req = GM_xmlhttpRequest({
          method: 'GET',
          url: pageUrl,
          headers: { 'Accept': 'text/html', 'User-Agent': 'Mozilla/5.0' },
          timeout: CONFIG.requestTimeout,
          onload(res) {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }

            if (res.status !== 200) {
              reject(new Error(`HTTP ${res.status}`));
              return;
            }

            try {
              const parser = new DOMParser();
              const doc = parser.parseFromString(res.responseText, 'text/html');
              let imageUrl = null;

              const og = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
              if (og) {
                const c = og.getAttribute('content');
                if (c && c.includes('vipr') && isImageUrl(c)) imageUrl = c;
              }

              if (!imageUrl) {
                const ids = ['image', 'img', 'picture', 'photo', 'show_image', 'fullimage'];
                for (const id of ids) {
                  const el = doc.getElementById(id);
                  if (el) {
                    if (el.tagName && el.tagName.toLowerCase() === 'img' && el.src && el.src.includes('vipr')) {
                      if (isImageUrl(el.src)) { imageUrl = el.src; break; }
                    } else {
                      const imgInside = el.querySelector && el.querySelector('img[src*="vipr"]');
                      if (imgInside && imgInside.src && isImageUrl(imgInside.src)) { imageUrl = imgInside.src; break; }
                    }
                  }
                }
              }

              if (!imageUrl) {
                const containers = doc.querySelectorAll('[id*="image"], [id*="img"], [class*="image"], [class*="img"], [class*="photo"]');
                for (const c of containers) {
                  const img = c.querySelector && c.querySelector('img[src*="vipr"]');
                  if (img && img.src && isImageUrl(img.src)) { imageUrl = img.src; break; }
                }
              }

              if (!imageUrl) {
                const imgs = doc.querySelectorAll('img[src*="vipr"]');
                for (const im of imgs) {
                  try {
                    const src = im.src;
                    if (!src) continue;
                    const lower = src.toLowerCase();
                    if (lower.includes('thumb') || lower.includes('_thumb') || lower.includes('_small') || lower.includes('/thumbs/')) continue;
                    if (isImageUrl(src)) { imageUrl = src; break; }
                  } catch (e) {}
                }
              }

              if (!imageUrl) {
                const anchors = doc.querySelectorAll('a[href*="vipr"]');
                for (const a of anchors) {
                  try {
                    const href = a.href;
                    if (!href) continue;
                    if (isImageUrl(href) && href.includes('vipr')) { imageUrl = href; break; }
                  } catch (e) {}
                }
              }

              if (imageUrl) resolve(fixProtocol(imageUrl));
              else reject(new Error('No image URL found'));
            } catch (err) { reject(err); }
          },
          onerror() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Network error'));
          },
          ontimeout() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Timeout'));
          }
        });
      } catch (err) {
        cleanup();
        reject(err);
      }

      if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
  }

  async function resolveAllVipr(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for(const p of pairs){
      if (p.fullUrl) {
        results.push({ ...p, error: null });
        continue;
      }

      if (!p.pageUrl) {
        results.push({ ...p, fullUrl: null, error: 'No page URL' });
        continue;
      }

      const url = p.pageUrl;
      const cachedUrl = getFromCache(url);
      if(cachedUrl){
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else {
        uncachedPairs.push(p);
      }
    }

    if(progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p =>
        resolveViprLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: err.message }))
      );

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

    return results;
  }

  // ==========================================
  // IMAGEBAM FUNCTIONS
  // ==========================================

  function extractImagebamLinks(post) {
    const links = new Set();
    try {
        const anchorTags = post.querySelectorAll('a[href*="imagebam.com"]');
        anchorTags.forEach(a => {
            try {
                const href = a.href;
                if (href && /imagebam\.com/i.test(href)) {
                    if (href.includes('/view/') || href.includes('/image/')) links.add(href);
                }
            } catch(e) {}
        });
        const imgTags = post.querySelectorAll('img');
        imgTags.forEach(img => {
            try {
                const src = img.src || '';
                if (/imagebam\.com/i.test(src) || /thumb|thumbnail|thumbnails/i.test(src)) {
                    const anchor = img.closest('a[href*="imagebam.com"]');
                    if (anchor && anchor.href) {
                        const href = anchor.href;
                        if (href.includes('/view/') || href.includes('/image/')) links.add(href);
                    }
                }
            } catch(e) {}
        });
    } catch(e) {}
    return Array.from(links).map(href => {
        const el = post.querySelector(`a[href="${href}"] img`);
        return { pageUrl: href, thumbUrl: el ? el.src : '', uniqueId: href.split('/').pop() || '' };
    });
}

  function resolveImagebamLink(link, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
      if (abortSignal && abortSignal.aborted) return reject(new Error('Cancelled'));
      const abortHandler = () => { try { req.abort(); } catch(e) {} };
      const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e) {} };
      const req = GM_xmlhttpRequest({
        method: 'GET',
        url: link,
        headers: { 'Accept': 'text/html', 'Referer': 'https://www.imagebam.com/', 'User-Agent': 'Mozilla/5.0' },
        timeout: CONFIG.requestTimeout,
        onload(res) {
          cleanup();
          if (abortSignal && abortSignal.aborted) return reject(new Error('Cancelled'));
          if (res.status !== 200) {
            reject(new Error(`HTTP ${res.status}`));
            return;
          }
          try {
            const parser = new DOMParser();
            const doc = parser.parseFromString(res.responseText, 'text/html');
            let imageUrl = null;
            const og = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
            if (og) {
              const c = og.getAttribute('content');
              if (c && /imagebam\.com/i.test(c) && isImageUrl(c)) {
                imageUrl = fixProtocol(c);
              }
            }
            if (!imageUrl) {
              const imgTags = doc.querySelectorAll('img[src]');
              for (const img of imgTags) {
                try {
                  const src = img.src;
                  if (src && /imagebam\.com/i.test(src) && isImageUrl(src)) {
                    if (/_o\.|_orig|original/i.test(src)) { imageUrl = fixProtocol(src); break; }
                    if (!imageUrl) imageUrl = fixProtocol(src);
                  }
                } catch(e) {}
              }
            }
            if (!imageUrl) {
              const anchors = doc.querySelectorAll('a[href]');
              for (const a of anchors) {
                try {
                  const href = a.href;
                  if (href && /imagebam\.com/i.test(href) && isImageUrl(href)) {
                    if (/_o\.|_orig|original/i.test(href)) { imageUrl = fixProtocol(href); break; }
                    if (!imageUrl) imageUrl = fixProtocol(href);
                  }
                } catch(e) {}
              }
            }
            if (imageUrl) resolve(imageUrl);
            else reject(new Error('No image URL found'));
          } catch (err) {
            reject(err);
          }
        },
        onerror() {
          cleanup();
          reject(new Error('Network error'));
        },
        ontimeout() {
          cleanup();
          reject(new Error('Timeout'));
        }
      });
      if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
  }

  async function resolveAllImagebam(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for(const p of pairs){
      const url = p.pageUrl;
      const cachedUrl = getFromCache(url);
      if(cachedUrl){
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else {
        uncachedPairs.push(p);
      }
    }

    if(progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p =>
        resolveImagebamLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: (err && err.message) || 'unknown' }))
      );

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

        return results;
  }

  // ==========================================
  // TURBOIMAGEHOST FUNCTIONS
  // ==========================================

  function extractTurboLinks(post) {
    const seen = new Map();
    try {
        const anchors = post.querySelectorAll('a[href*="turboimagehost.com"], a[href*="turboimg"], a[href*="turboimage"]');
        anchors.forEach(a => {
            try {
                const href = a.href;
                if (!href) return;
                let thumb = '';
                const img = a.querySelector('img');
                if (img && img.src) thumb = img.src;
                const key = thumb || href;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: href,
                        thumbUrl: thumb,
                        uniqueId: href.split('/').pop() || ''
                    });
                } else {
                    const existing = seen.get(key);
                    if (existing && !existing.pageUrl && href) {
                        existing.pageUrl = href;
                    }
                }
            } catch (err) {}
        });

        const imgs = post.querySelectorAll('img[src*="turboimagehost.com"], img[src*="turboimg"], img[src*="turboimage"]');
        imgs.forEach(img => {
            try {
                const src = img.src;
                if (!src) return;
                const key = src;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: '',
                        thumbUrl: src,
                        uniqueId: src.split('/').pop() || ''
                    });
                }
            } catch (e) {}
        });
    } catch (e) {}
    return Array.from(seen.values());
}

    function resolveTurboLink(pageUrl, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
      if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
      if (!pageUrl) { reject(new Error('No page URL to resolve')); return; }

      const abortHandler = () => { try { if(req) req.abort(); } catch(e){} };
      const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e){} };

      let req;
      try {
        req = GM_xmlhttpRequest({
          method: 'GET',
          url: pageUrl,
          headers: {
            'Accept': 'text/html',
            'User-Agent': 'Mozilla/5.0',
            'Referer': location.origin + '/'
          },
          timeout: CONFIG.requestTimeout,
          onload(res) {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }

            if (res.status !== 200) {
              reject(new Error(`HTTP ${res.status}`));
              return;
            }

            try {
              const parser = new DOMParser();
              const doc = parser.parseFromString(res.responseText, 'text/html');
              let imageUrl = null;

              const og = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
              if (og) {
                const c = og.getAttribute('content');
                if (c && c.toLowerCase().includes('turbo') && isImageUrl(c)) imageUrl = c;
              }

              if (!imageUrl) {
                const ids = ['image', 'img', 'picture', 'photo', 'show_image', 'fullimage', 'main-image', 'image_view', 'img_object'];
                for (const id of ids) {
                  const el = doc.getElementById(id);
                  if (el) {
                    if (el.tagName && el.tagName.toLowerCase() === 'img' && el.src && el.src.includes('turbo')) {
                      if (isImageUrl(el.src)) { imageUrl = el.src; break; }
                    } else {
                      const imgInside = el.querySelector && el.querySelector('img[src*="turbo"]');
                      if (imgInside && imgInside.src && isImageUrl(imgInside.src)) {
                        imageUrl = imgInside.src;
                        break;
                      }
                    }
                  }
                }
              }

              if (!imageUrl) {
                const containers = doc.querySelectorAll('[id*="image"], [id*="img"], [class*="image"], [class*="img"], [class*="photo"], [class*="viewer"]');
                for (const c of containers) {
                  const img = c.querySelector && c.querySelector('img[src*="turbo"]');
                  if (img && img.src && isImageUrl(img.src)) {
                    imageUrl = img.src;
                    break;
                  }
                }
              }

              if (!imageUrl) {
                const imgs = doc.querySelectorAll('img[src*="turbo"]');
                for (const im of imgs) {
                  try {
                    const src = im.src;
                    if (!src) continue;
                    const lower = src.toLowerCase();
                    if (lower.includes('thumb') || lower.includes('_thumb') || lower.includes('_small') || lower.includes('/thumbs/')) continue;
                    if (isImageUrl(src)) { imageUrl = src; break; }
                  } catch (e) {}
                }
              }

              if (!imageUrl) {
                const anchors = doc.querySelectorAll('a[href*="turbo"]');
                for (const a of anchors) {
                  try {
                    const href = a.href;
                    if (!href) continue;
                    if (isImageUrl(href) && href.toLowerCase().includes('turbo')) {
                      imageUrl = href;
                      break;
                    }
                  } catch (e) {}
                }
              }

              if (imageUrl) resolve(fixProtocol(imageUrl));
              else reject(new Error('No image URL found'));
            } catch (err) {
              reject(err);
            }
          },
          onerror() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Network error'));
          },
          ontimeout() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Timeout'));
          }
        });
      } catch (err) {
        cleanup();
        reject(err);
      }

      if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
  }

  async function resolveAllTurbo(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for(const p of pairs){
      const url = p.pageUrl;
      const cachedUrl = url ? getFromCache(url) : null;
      if(cachedUrl){
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else if (url) {
        uncachedPairs.push(p);
      } else {
        results.push({ ...p, fullUrl: null, error: 'No page URL' });
      }
    }

    if(progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p =>
        resolveTurboLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: err.message }))
      );

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

       return results;
  }

  // ==========================================
  // PIXHOST FUNCTIONS
  // ==========================================

  function extractPixhostLinks(post) {
    const seen = new Map();
    try {
        const anchors = post.querySelectorAll('a[href*="pixhost.to"]');
        anchors.forEach(a => {
            try {
                const href = a.href;
                if (!href) return;
                let thumb = '';
                const img = a.querySelector('img[src*="pixhost"]');
                if (img && img.src) thumb = img.src;
                const key = thumb || href;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: href,
                        thumbUrl: thumb,
                        uniqueId: href.split('/').pop() || ''
                    });
                } else {
                    const existing = seen.get(key);
                    if (existing && !existing.pageUrl && href) {
                        existing.pageUrl = href;
                    }
                }
            } catch (err) {}
        });

        const imgs = post.querySelectorAll('img[src*="pixhost"]');
        imgs.forEach(img => {
            try {
                const src = img.src;
                if (!src) return;
                const key = src;
                if (!seen.has(key)) {
                    seen.set(key, {
                        pageUrl: '',
                        thumbUrl: src,
                        uniqueId: src.split('/').pop() || ''
                    });
                }
            } catch (e) {}
        });
    } catch (e) {}
    return Array.from(seen.values());
}

    function resolvePixhostLink(pageUrl, abortSignal) {
    return withRetry(() => new Promise((resolve, reject) => {
      if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
      if (!pageUrl) { reject(new Error('No page URL to resolve')); return; }

      const abortHandler = () => { try { if(req) req.abort(); } catch(e){} };
      const cleanup = () => { try { if(abortSignal) abortSignal.removeEventListener('abort', abortHandler); } catch(e){} };

      let req;
      try {
        req = GM_xmlhttpRequest({
          method: 'GET',
          url: pageUrl,
          headers: { 'Accept': 'text/html', 'User-Agent': 'Mozilla/5.0' },
          timeout: CONFIG.requestTimeout,
          onload(res) {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }

            if (res.status !== 200) {
              reject(new Error(`HTTP ${res.status}`));
              return;
            }

            try {
              const parser = new DOMParser();
              const doc = parser.parseFromString(res.responseText, 'text/html');
              let imageUrl = null;

              const og = doc.querySelector('meta[property="og:image"], meta[name="og:image"]');
              if (og) {
                const c = og.getAttribute('content');
                if (c && c.includes('pixhost') && isImageUrl(c)) imageUrl = c;
              }

              if (!imageUrl) {
                const ids = ['image', 'img', 'picture', 'photo', 'show_image'];
                for (const id of ids) {
                  const el = doc.getElementById(id);
                  if (el) {
                    if (el.tagName && el.tagName.toLowerCase() === 'img' && el.src && el.src.includes('pixhost')) {
                      if (isImageUrl(el.src)) { imageUrl = el.src; break; }
                    } else {
                      const imgInside = el.querySelector && el.querySelector('img[src*="pixhost"]');
                      if (imgInside && imgInside.src && isImageUrl(imgInside.src)) {
                        imageUrl = imgInside.src;
                        break;
                      }
                    }
                  }
                }
              }

              if (!imageUrl) {
                const containers = doc.querySelectorAll('[id*="image"], [id*="img"], [class*="image"], [class*="img"]');
                for (const c of containers) {
                  const img = c.querySelector && c.querySelector('img[src*="pixhost"]');
                  if (img && img.src && isImageUrl(img.src)) {
                    imageUrl = img.src;
                    break;
                  }
                }
              }

              if (!imageUrl) {
                const imgs = doc.querySelectorAll('img[src*="pixhost"]');
                for (const im of imgs) {
                  try {
                    const src = im.src;
                    if (!src) continue;
                    const lower = src.toLowerCase();
                    if (lower.includes('thumb') || lower.includes('_thumb') || lower.includes('_small') || lower.includes('thumbnails')) continue;
                    if (isImageUrl(src)) { imageUrl = src; break; }
                  } catch (e) {}
                }
              }

              if (!imageUrl) {
                const anchors = doc.querySelectorAll('a[href*="pixhost"]');
                for (const a of anchors) {
                  try {
                    const href = a.href;
                    if (!href) continue;
                    if (isImageUrl(href) && href.includes('img') && href.includes('pixhost')) {
                      imageUrl = href;
                      break;
                    }
                  } catch (e) {}
                }
              }

              if (imageUrl) resolve(fixProtocol(imageUrl));
              else reject(new Error('No image URL found'));
            } catch (err) { reject(err); }
          },
          onerror() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Network error'));
          },
          ontimeout() {
            cleanup();
            if (abortSignal && abortSignal.aborted) { reject(new Error('Cancelled')); return; }
            reject(new Error('Timeout'));
          }
        });
      } catch (err) {
        cleanup();
        reject(err);
      }

      if (abortSignal) abortSignal.addEventListener('abort', abortHandler);
    }), abortSignal);
  }

  async function resolveAllPixhost(pairs, progressCallback, externalAbortSignal) {
    const results = [];
    const signal = externalAbortSignal || { aborted: false };
    const uncachedPairs = [];

    for(const p of pairs){
      const url = p.pageUrl;
      const cachedUrl = url ? getFromCache(url) : null;
      if(cachedUrl){
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else if (url) {
        uncachedPairs.push(p);
      } else {
        results.push({ ...p, fullUrl: null, error: 'No page URL' });
      }
    }

    if(progressCallback) progressCallback(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p =>
        resolvePixhostLink(p.pageUrl, signal).then(full => {
          addToCache(p.pageUrl, full);
          return { ...p, fullUrl: full, error: null };
        }).catch(err => ({ ...p, fullUrl: null, error: err.message }))
      );

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCallback) progressCallback(results.length, pairs.length);
      if (signal.aborted) throw new Error('Cancelled');
      if (b < batches.length - 1 && !signal.aborted) await sleep(CONFIG.batchDelay);
    }

        return results;
  }

  // ==========================================
  // PIMPANDHOST FUNCTIONS
  // ==========================================

  function normalizePmpKey(u) {
    if (!u) return '';
    try {
      const parsed = new URL(u);
      const path = parsed.pathname || '/';
      const base = (path.split('/').pop() || '').split('?')[0];
      return stripExtAndLower(base);
    } catch (e) {
      return stripExtAndLower(String(u).split('/').pop());
    }
  }

  function extractPimpLinks(post) {
    const out = [];
    try {
      const anchors = post.querySelectorAll('a[href*="pimpandhost.com/image"], a[href*="filesor.com"], a[href*="pimpandhost.com"]');
      anchors.forEach(a => {
        try {
          const h = a.href;
          if (!h) return;
          const imgs = a.querySelectorAll('img');
          let thumb = '';
          if (imgs && imgs.length) thumb = imgs[0].src || '';
          out.push({ pageUrl: h, thumbUrl: thumb || h, uniqueId: (h.split('/').pop() || '') });
        } catch (e) {}
      });
      const imgs = post.querySelectorAll('img[src*="filesor.com"], img[src*="pimpandhost.com"]');
      imgs.forEach(img => {
        try {
          const s = img.src;
          if (!s) return;
          out.push({ pageUrl: s, thumbUrl: s, uniqueId: (s.split('/').pop() || '') });
        } catch (e) {}
      });
    } catch (e) {}
    const seen = new Set();
    return out.filter(item => {
      const k = (item.pageUrl || '') + '|' + (item.thumbUrl || '');
      if (seen.has(k)) return false;
      seen.add(k);
      return true;
    });
  }

  function dedupePmpPairsCanonical(pairs) {
    const map = new Map();
    const ordered = [];
    pairs.forEach((p, idx) => {
      const raw = p.uniqueId || '';
      const key = p.thumbUrl ? normalizePmpKey(p.thumbUrl) : (raw ? stripExtAndLower(raw) : normalizePmpKey(p.pageUrl) || String(idx));
      const k = key || String(idx);
      if (!map.has(k)) {
        ordered.push(k);
        map.set(k, { thumbUrl: p.thumbUrl || null, pageUrl: p.pageUrl || null, uniqueId: raw || null, order: idx });
      } else {
        const ex = map.get(k);
        if (!ex.thumbUrl && p.thumbUrl) ex.thumbUrl = p.thumbUrl;
        if (!ex.pageUrl && p.pageUrl) ex.pageUrl = p.pageUrl;
        if (!ex.uniqueId && raw) ex.uniqueId = raw;
      }
    });
    return ordered.map(k => {
      const v = map.get(k);
      return { thumbUrl: v.thumbUrl, pageUrl: v.pageUrl, uniqueId: v.uniqueId, order: v.order };
    });
  }

  function choosePmpResolveCandidate(p) {
    const page = p.pageUrl || '';
    const thumb = p.thumbUrl || '';
    if (thumb && isImageUrl(thumb)) return thumb;
    return page || thumb;
  }

  function resolvePmpLinkAdapter(candidate, abortSignal) {
    if (!candidate) return Promise.reject(new Error('No URL'));
    if (abortSignal && abortSignal.aborted) return Promise.reject(new Error('Cancelled'));
    try {
      let c = candidate;
      try {
        const parsed = new URL(c);
        let path = parsed.pathname || '';

        if (/_s\.(jpg|jpeg|png|gif|webp)$/i.test(path)) {
          path = path.replace(/_s\.(jpg|jpeg|png|gif|webp)$/i, '.$1');
          parsed.pathname = path;
          c = parsed.toString();
        } else if (/_m\.(jpg|jpeg|png|gif|webp)$/i.test(path) || /_sm\.(jpg|jpeg|png|gif|webp)$/i.test(path)) {
          path = path.replace(/_(m|sm)\.(jpg|jpeg|png|gif|webp)$/i, '.$2');
          parsed.pathname = path;
          c = parsed.toString();
        } else if (/_l\.(jpg|jpeg|png|gif|webp)$/i.test(path)) {
          path = path.replace(/_l\.(jpg|jpeg|png|gif|webp)$/i, '.$1');
          parsed.pathname = path;
          c = parsed.toString();
        } else if (/\/upload\/.*_(s|m|sm|l)\.(jpg|jpeg|png|gif|webp)$/i.test(path)) {
          path = path.replace(/_(s|m|sm|l)\.(jpg|jpeg|png|gif|webp)$/i, '.$2');
          parsed.pathname = path;
          c = parsed.toString();
        }
      } catch (e) {}

      c = fixProtocol(c);
      return Promise.resolve(c);
    } catch (err) {
      return Promise.reject(err);
    }
  }

  async function resolveAllPimp(pairs, progressCb, externalSignal) {
    const results = [];
    const signal = externalSignal || { aborted: false };
    const uncachedPairs = [];

    for (const p of pairs) {
      const candidate = p.resolveUrl || p.pageUrl || p.thumbUrl || '';
      const cachedUrl = candidate ? getFromCache(candidate) : null;
      if (cachedUrl) {
        results.push({ ...p, fullUrl: cachedUrl, error: null });
      } else if (candidate) {
        uncachedPairs.push(p);
      } else {
        results.push({ ...p, fullUrl: null, error: 'No URL' });
      }
    }

    if (progressCb) progressCb(results.length, pairs.length);

    const batches = [];
    for (let i = 0; i < uncachedPairs.length; i += CONFIG.maxConcurrent) {
      batches.push(uncachedPairs.slice(i, i + CONFIG.maxConcurrent));
    }

    for (let b = 0; b < batches.length; b++) {
      if (signal.aborted) throw new Error('Cancelled');

      const batch = batches[b];
      const promises = batch.map(p => {
        const candidate = p.resolveUrl || p.pageUrl || p.thumbUrl || '';
        return resolvePmpLinkAdapter(candidate, signal)
          .then(full => {
            addToCache(candidate, full);
            return { ...p, fullUrl: full, error: null };
          })
          .catch(err => ({ ...p, fullUrl: null, error: err && err.message || String(err) }));
      });

      const res = await Promise.all(promises);
      results.push(...res);

      if (progressCb) progressCb(results.length, pairs.length);

      if (signal.aborted) throw new Error('Cancelled');

      if (b < batches.length - 1) await sleep(CONFIG.batchDelay);
    }

    return results;
  }

    function createWaveElement() {
    const container = document.createElement('span');
    container.className = 'bracket-flash';

    for (let i = 1; i <= 3; i++) {
      const wave = document.createElement('span');
      wave.className = 'b' + i + '-wave';
      wave.textContent = '▌';
      container.appendChild(wave);
    }

    return container;
  }

      function createPillElement(successCount, totalCount) {
    if (typeof successCount !== 'number' || typeof totalCount !== 'number' || totalCount === 0) {
      return null;
    }
    const percentage = (successCount / totalCount) * 100;
    let colorClass;
    if (percentage >= 100) {
      colorClass = 'green';
    } else if (percentage >= 69) {
      colorClass = 'yellow';
    } else {
      colorClass = 'red';
    }

    const pill = document.createElement('span');
    pill.className = 'pill ' + colorClass;
    pill.textContent = successCount + '/' + totalCount;
    return pill;
  }

      function resetZipUI(mainBtn, progressWrap, idleLabel) {
    mainBtn.disabled = false;
    mainBtn.innerHTML = idleLabel + ' <span class="arrow">▼</span>';

    if (CONFIG.PROGRESS_PERSIST === 0) {
      progressWrap.classList.remove('active');
    }

    const fileBar = progressWrap.querySelector('.vgt-progress-row:nth-child(1) .vgt-progress-bar-fill');
    const filePercent = progressWrap.querySelector('.vgt-progress-row:nth-child(1) .vgt-progress-percent');
    const totalBar = progressWrap.querySelector('.vgt-progress-row:nth-child(2) .vgt-progress-bar-fill');
    const totalPercent = progressWrap.querySelector('.vgt-progress-row:nth-child(2) .vgt-progress-percent');
    const status = progressWrap.querySelector('.vgt-progress-status');
    const zipCancelBtn = progressWrap.querySelector('.vgt-progress-footer .resolver-btn-cancel');

    if (zipCancelBtn) zipCancelBtn.classList.remove('active');
    if (CONFIG.PROGRESS_PERSIST === 0) {
      if (fileBar) fileBar.style.width = '0%';
      if (filePercent) filePercent.textContent = '0%';
      if (totalBar) totalBar.style.width = '0%';
      if (totalPercent) totalPercent.textContent = '0%';
    }
    if (status && CONFIG.PROGRESS_PERSIST === 0) {
      status.textContent = '';
      status.className = 'vgt-progress-status';
    }
  }

        async function downloadImages(mergedWithResolve, postId, mainBtn, progressWrap, idleLabel, resolver, disableOtherButtons, enableOtherButtons, settings) {
    if (settings.zipped && !JSZip) {
      showNotice('ZIP library not loaded. Disable uBlock/Privacy Badger and reload.', 5000);
      return;
    }

    const abortController = new AbortController();
    const activeRequests = [];
    const requestProgress = [];
    let isCancelled = false;

    let completed = 0;
    let successCount = 0;

    let zip = settings.zipped ? new JSZip() : null;
    let zipFileCount = 0;
    const pendingBlobUrls = [];

    const usedPaths = new Set();
    const usedFlatNames = new Set();

    function ensureUniquePath(path) {
      let p = String(path || '').trim();
      if (!p) p = 'file';
      if (!usedPaths.has(p)) {
        usedPaths.add(p);
        return p;
      }
      const parts = p.split('/');
      const base = parts.pop();
      const dir = parts.length ? parts.join('/') : '';
      const lastDot = base.lastIndexOf('.');
      const ext = lastDot > 0 ? base.slice(lastDot) : '';
      const stem = lastDot > 0 ? base.slice(0, lastDot) : base;
      let i = 2;
      while (true) {
        const candidateBase = ext ? stem + ' (' + i + ')' + ext : stem + ' (' + i + ')';
        const candidate = dir ? dir + '/' + candidateBase : candidateBase;
        if (!usedPaths.has(candidate)) {
          usedPaths.add(candidate);
          return candidate;
        }
        i++;
      }
    }

    function ensureUniqueFlatName(name) {
      let n = String(name || '').trim();
      if (!n) n = 'file';
      if (!usedFlatNames.has(n)) {
        usedFlatNames.add(n);
        return n;
      }
      const lastDot = n.lastIndexOf('.');
      const ext = lastDot > 0 ? n.slice(lastDot) : '';
      const stem = lastDot > 0 ? n.slice(0, lastDot) : n;
      let i = 2;
      while (true) {
        const candidate = ext ? stem + ' (' + i + ')' + ext : stem + ' (' + i + ')';
        if (!usedFlatNames.has(candidate)) {
          usedFlatNames.add(candidate);
          return candidate;
        }
        i++;
      }
    }

    zipOperations.set(postId, {
      abortController: abortController,
      activeRequests: activeRequests,
      mainBtn: mainBtn,
      idleLabel: idleLabel,
      progressWrap: progressWrap,
      cancel: function () {
        isCancelled = true;
        abortController.abort();
        for (let i = 0; i < activeRequests.length; i++) {
          try { activeRequests[i].abort(); } catch (e) { console.error('[Unified] request abort error:', e); }
        }
        activeRequests.length = 0;
        requestProgress.forEach(function (rp) {
          if (rp.intervalId) clearInterval(rp.intervalId);
        });
        requestProgress.length = 0;
        if (settings.zipped) {
          zip = null;
        } else {
          pendingBlobUrls.forEach(function (url) {
            try { URL.revokeObjectURL(url); } catch (e) { console.error('[Unified] revoke error:', e); }
          });
          pendingBlobUrls.length = 0;
        }
      }
    });

    const fileRow = progressWrap.querySelector('.vgt-progress-row:nth-child(1)');
    const totalRow = progressWrap.querySelector('.vgt-progress-row:nth-child(2)');
    const statusText = progressWrap.querySelector('.vgt-progress-status');
    const zipCancelBtn = progressWrap.querySelector('.vgt-progress-footer .resolver-btn-cancel');

    if (zipCancelBtn) zipCancelBtn.classList.add('active');

    function updateFileProgress(percent) {
      const fill = fileRow.querySelector('.vgt-progress-bar-fill');
      const text = fileRow.querySelector('.vgt-progress-percent');
      fill.style.width = percent + '%';
      text.textContent = Math.floor(percent) + '%';
    }

    function updateTotalProgress(percent) {
      const fill = totalRow.querySelector('.vgt-progress-bar-fill');
      const text = totalRow.querySelector('.vgt-progress-percent');
      fill.style.width = percent + '%';
      text.textContent = Math.floor(percent) + '%';
    }

    function updateStatus(text, colorClass, showWave, success, total) {
      statusText.className = 'vgt-progress-status' + (colorClass ? ' ' + colorClass : '');
      statusText.textContent = '';

      if (showWave) {
        statusText.appendChild(createWaveElement());
      }

      const strong = document.createElement('strong');
      strong.textContent = text;
      statusText.appendChild(strong);

      if (typeof success === 'number' && typeof total === 'number') {
        const pill = createPillElement(success, total);
        if (pill) {
          statusText.appendChild(pill);
        }
      }
    }

    function finishDownload() {
      zipOperations.delete(postId);
      setPostProcessing(getBasePostId(postId), false);
      enableOtherButtons();
    }

    try {
      mainBtn.disabled = true;
      mainBtn.innerHTML = '<div class="spinner-resolving"><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span></div> Resolving';
      progressWrap.classList.add('active');
      updateFileProgress(0);
      updateTotalProgress(0);

      updateStatus('Resolving URLs', 'resolving', true);

        const resolvedPairs = await resolver(
        mergedWithResolve,
        function (current, total) {
          updateStatus('Resolving ' + current + '/' + total, 'resolving', true);
        },
        abortController.signal
      );

      if (isCancelled) throw new Error('Cancelled');

      const validPairs = resolvedPairs.filter(function (p) { return p.fullUrl; });

      if (validPairs.length === 0) {
        throw new Error('No images to download');
      }

      mainBtn.innerHTML = '<div class="spinner-downloading"><span></span><span></span><span></span></div> Downloading';
      updateStatus('Downloading 0/' + validPairs.length, 'downloading', true);

      const total = validPairs.length;
      const batchSize = CONFIG.zipConcurrent;

        for (let i = 0; i < validPairs.length; i += batchSize) {
        if (isCancelled) throw new Error('Cancelled');

        const batch = validPairs.slice(i, i + batchSize);
        const batchProgress = new Array(batch.length).fill(0);

        const batchPromises = batch.map(function (pair, batchIndex) {
          return new Promise(function (resolve) {
            if (isCancelled) {
              resolve();
              return;
            }

            let resolved = false;

            function safeResolve(incrementSuccess) {
              if (resolved) return;
              resolved = true;
              completed++;
              if (incrementSuccess) successCount++;
              updateStatus('Downloading ' + completed + '/' + total, 'downloading', true);
              updateTotalProgress((completed / total) * 100);
              updateFileProgress(0);
              resolve();
            }

            const stallMonitor = { old: 0, new: 0, intervalId: null, maxProgress: 0 };

            const request = GM_xmlhttpRequest({
              method: 'GET',
              url: pair.fullUrl,
              responseType: 'blob',
              timeout: CONFIG.downloadTimeout,
              headers: {
                'Referer': pair.pageUrl || pair.fullUrl
              },
              onprogress: function (progress) {
                stallMonitor.new = progress.loaded;
                if (progress.total > 0) {
                  const currentProgress = (progress.loaded / progress.total) * 100;
                  if (currentProgress > stallMonitor.maxProgress) {
                    stallMonitor.maxProgress = currentProgress;
                    batchProgress[batchIndex] = currentProgress;
                    const avgProgress = batchProgress.reduce((sum, val) => sum + val, 0) / batch.length;
                    updateFileProgress(avgProgress);
                  }
                }
              },
              onload: function (response) {
                if (stallMonitor.intervalId) clearInterval(stallMonitor.intervalId);

                if (isCancelled) {
                  resolve();
                  return;
                }

                if (response.status === 200 && response.response && isValidImageContentType(response.responseHeaders)) {
                  const fileBlob = response.response;

                  if (fileBlob.size < CONFIG.minImageSize) {
                    safeResolve(false);
                    return;
                  }

                  let filename = pair.fullUrl.split('/').pop().split('?')[0] || 'image.jpg';
                  filename = sanitizeWinSegment(filename);

                  if (settings.zipped) {
                    try {
                      filename = ensureUniquePath(filename);
                      zip.file(filename, fileBlob);
                      zipFileCount++;
                    } catch (e) {
                      console.error('[Unified] Failed to add file to ZIP:', e);
                    }
                    safeResolve(false);
                  } else {
                    const title = sanitizeWinSegment(getThreadTitle());
                    let saveAsName;

                    if (window.isFF) {
                      saveAsName = title + ' #' + settings.postNumber + ' - ' + ensureUniqueFlatName(filename);
                    } else {
                      filename = ensureUniquePath(filename);
                      saveAsName = title + '/#' + settings.postNumber + '/' + filename;
                    }

                    const blobUrl = URL.createObjectURL(fileBlob);
                    pendingBlobUrls.push(blobUrl);

                    GM_download({
                      url: blobUrl,
                      name: saveAsName,
                      onload: function () {
                        try {
                          URL.revokeObjectURL(blobUrl);
                          const idx = pendingBlobUrls.indexOf(blobUrl);
                          if (idx > -1) pendingBlobUrls.splice(idx, 1);
                        } catch (e) { console.error('[Unified] revoke error:', e); }
                        safeResolve(true);
                      },
                      onerror: function (err) {
                        console.error('[Unified] GM_download failed: ' + saveAsName, err);
                        try {
                          URL.revokeObjectURL(blobUrl);
                          const idx = pendingBlobUrls.indexOf(blobUrl);
                          if (idx > -1) pendingBlobUrls.splice(idx, 1);
                        } catch (e) { console.error('[Unified] revoke error:', e); }
                        safeResolve(false);
                      }
                    });
                  }
                } else {
                  safeResolve(false);
                }
              },
              onerror: function () {
                if (stallMonitor.intervalId) clearInterval(stallMonitor.intervalId);
                safeResolve(false);
              },
              ontimeout: function () {
                if (stallMonitor.intervalId) clearInterval(stallMonitor.intervalId);
                safeResolve(false);
              }
            });

            activeRequests.push(request);

            stallMonitor.intervalId = setInterval(function () {
              if (stallMonitor.old === stallMonitor.new) {
                try {
                  request.abort();
                  clearInterval(stallMonitor.intervalId);
                  safeResolve(false);
                } catch (e) { console.error('[Unified] stall abort error:', e); }
              } else {
                stallMonitor.old = stallMonitor.new;
              }
            }, CONFIG.stallTimeout);

            requestProgress.push(stallMonitor);
          });
        });

        await Promise.all(batchPromises);

        if (i + batchSize < validPairs.length && !isCancelled) {
          await sleep(120);
        }
      }

      if (isCancelled) throw new Error('Cancelled');

      if (settings.zipped) {
        if (zipFileCount === 0) {
          throw new Error('No images could be downloaded');
        }

        updateStatus('Creating ZIP archive', 'compressing', true);

        let zipBlob = null;
        try {
          zipBlob = await zip.generateAsync({ type: 'blob' });
        } catch (zipError) {
          console.error('[Unified] generateAsync failed:', zipError);
          throw new Error('ZIP creation failed');
        }

        if (!zipBlob) {
          throw new Error('ZIP blob is empty');
        }

        if (isCancelled) throw new Error('Cancelled');

        updateStatus('Saving', 'compressing', true);

        const zipName = getSafeZipName() + '.zip';
        saveAs(zipBlob, zipName);

        updateTotalProgress(100);
        updateFileProgress(100);

        updateStatus('Done ;)', 'complete', false, zipFileCount, total);

        mainBtn.textContent = 'fin';

        showNotice('✓ Saved ' + zipName + ' (' + zipFileCount + '/' + total + ' images)', 3000, true);

        zip = null;
        zipBlob = null;
      } else {
        updateTotalProgress(100);
        updateFileProgress(100);

        if (successCount === 0) {
          updateStatus('Completed', 'complete', false, successCount, total);
        } else {
          updateStatus('Done ;)', 'complete', false, successCount, total);
        }

        mainBtn.textContent = 'fin';

        if (successCount === total) {
          showNotice('✓ Saved ' + successCount + ' images', 3000, true);
        } else {
          showNotice('✓ Saved ' + successCount + '/' + total + ' images', 3000, true);
        }
      }

      requestProgress.length = 0;

      if (CONFIG.PROGRESS_PERSIST === 0) {
        setTimeout(function () {
          resetZipUI(mainBtn, progressWrap, idleLabel);
          finishDownload();
        }, 3000);
      } else {
        resetZipUI(mainBtn, progressWrap, idleLabel);
        finishDownload();
      }

    } catch (error) {
      for (let r = 0; r < activeRequests.length; r++) {
        try { activeRequests[r].abort(); } catch (e) { console.error('[Unified] cleanup abort error:', e); }
      }
      activeRequests.length = 0;
      requestProgress.forEach(function (rp) {
        if (rp.intervalId) clearInterval(rp.intervalId);
      });
      requestProgress.length = 0;

      if (settings.zipped) {
        zip = null;
      } else {
        pendingBlobUrls.forEach(function (url) {
          try { URL.revokeObjectURL(url); } catch (e) { console.error('[Unified] revoke error:', e); }
        });
        pendingBlobUrls.length = 0;
      }

      const errorMsg = error.message || 'Unknown error';
      const isCancelError = errorMsg.toLowerCase().indexOf('cancel') > -1;

      if (isCancelError) {
        updateStatus('Cancelled', 'error', false);
        showNotice('Download cancelled', 2000);
      } else {
        updateStatus('Error: ' + errorMsg, 'error', false);
        showNotice('Download failed: ' + errorMsg, 5000);
      }

      setTimeout(function () {
        resetZipUI(mainBtn, progressWrap, idleLabel);
        finishDownload();
      }, 2000);
    }
  }

    function cancelZipDownload(postId) {
    const op = zipOperations.get(postId);
    if (op && op.cancel) {
      try {
        op.cancel();
      } catch (e) {
        console.error('[Unified] cancel error:', e);
      }
    }
    zipOperations.delete(postId);
  }

  // ==========================================
  // TITLE COPY BUTTON
  // ==========================================

  const TITLE_COPY_IMAGE_HOSTS = [
    'imx.to', 'imagevenue.com', 'imgbox.com', 'vipr.im',
    'imagebam.com', 'turboimagehost.com', 'pixhost.to', 'pimpandhost.com'
  ];

  const TITLE_COPY_IMAGE_EXTENSIONS = ['.jpg', '.jpeg', '.png', '.gif', '.webp'];

  const TITLE_COPY_ICONS = {
    copy: `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
      <rect width="14" height="14" x="8" y="8" rx="2" ry="2"/>
      <path d="M4 16c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2"/>
    </svg>`,
    check: `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round">
      <polyline points="20 6 9 17 4 12"/>
    </svg>`
  };

  function titleCopyHasImages() {
    const contentSelectors = [
      '.message-body',
      '.bbWrapper',
      '.message-content',
      'article.message-body',
      '.post-content'
    ];

    let contentArea = null;
    for (const selector of contentSelectors) {
      contentArea = document.querySelector(selector);
      if (contentArea) break;
    }

    const searchScope = contentArea || document;

    const hasImageHost = TITLE_COPY_IMAGE_HOSTS.some(host =>
      searchScope.querySelector(`a[href*="${host}"]`)
    );
    if (hasImageHost) return true;

    const hasDirectImage = TITLE_COPY_IMAGE_EXTENSIONS.some(ext =>
      searchScope.querySelector(`img[src*="${ext}"], a[href*="${ext}"]`)
    );
    return hasDirectImage;
  }

  function setTitleCopyButtonState(button, state) {
    const states = {
      default: { icon: TITLE_COPY_ICONS.copy, class: '', tooltip: 'Copy title' },
      success: { icon: TITLE_COPY_ICONS.check, class: 'viper-copy-btn--success', tooltip: 'Copied' }
    };

    const { icon, class: className, tooltip } = states[state];

    button.innerHTML = icon;
    button.className = `viper-copy-btn ${className}`.trim();
    button.dataset.tooltip = tooltip;

    if (state !== 'default') {
      button.classList.add('viper-copy-btn--animate');
    }
  }

  function createTitleCopyButton() {
    const button = document.createElement('button');
    button.className = 'viper-copy-btn';
    button.innerHTML = TITLE_COPY_ICONS.copy;
    button.dataset.tooltip = 'Copy title';
    button.type = 'button';

    button.addEventListener('click', async function(e) {
      e.preventDefault();
      e.stopPropagation();

      const title = getThreadTitle();

      try {
        await GM_setClipboard(title);
        setTitleCopyButtonState(button, 'success');
      } catch (err) {
        console.error('[Unified] Title copy failed:', err);
      }

      setTimeout(function() {
        setTitleCopyButtonState(button, 'default');
      }, 510);
    });

    return button;
  }

  function insertTitleCopyButton() {
    if (!CONFIG.COPY_TITLE_BUTTON) return;
    if (!titleCopyHasImages() || document.querySelector('.viper-copy-btn')) return;

    const button = createTitleCopyButton();

    const titleEl = document.querySelector(
      '.p-title-value, h1.thread-title, .thread-title-text'
    ) || document.querySelector('h1');

    if (!titleEl) return;

    const wrapper = document.createElement('span');
    wrapper.style.display = 'inline-flex';
    wrapper.style.alignItems = 'center';

    titleEl.parentNode.insertBefore(wrapper, titleEl);
    wrapper.appendChild(titleEl);
    wrapper.appendChild(button);
  }

    function downloadWithRetry(url, referer, maxAttempts) {
    return new Promise(function (resolve, reject) {
        let attempt = 0;
        function tryDownload() {
            attempt++;
            GM_xmlhttpRequest({
                method: 'GET',
                url: url,
                responseType: 'blob',
                timeout: CONFIG.downloadTimeout,
                headers: { 'Referer': referer, 'User-Agent': 'Mozilla/5.0' },
                onload(res) {
                    if (res.status !== 200) {
                        if (attempt < maxAttempts) {
                            setTimeout(tryDownload, CONFIG.retryDelay * attempt);
                        } else {
                            reject(new Error('HTTP ' + res.status));
                        }
                        return;
                    }
                    if (!res.response || !isValidImageContentType(res.responseHeaders)) {
                        reject(new Error('Invalid content type'));
                        return;
                    }
                    const blobUrl = URL.createObjectURL(res.response);
                    const a = document.createElement('a');
                    a.href = blobUrl;
                    a.download = sanitizeWinSegment(url.split('/').pop().split('?')[0] || 'image');
                    const cleanup = () => {
                        try { URL.revokeObjectURL(blobUrl); } catch (e) {}
                    };
                    safeAppendToBody(a);
                    try {
                        a.click();
                    } finally {
                        setTimeout(cleanup, 100);
                    }
                    a.remove();
                    resolve();
                },
                onerror() {
                    if (attempt < maxAttempts) {
                        setTimeout(tryDownload, CONFIG.retryDelay * attempt);
                    } else {
                        reject(new Error('Network error'));
                    }
                },
                ontimeout() {
                    if (attempt < maxAttempts) {
                        setTimeout(tryDownload, CONFIG.retryDelay * attempt);
                    } else {
                        reject(new Error('Timeout'));
                    }
                }
            });
        }
        tryDownload();
    });
}

  function openGallery(resolvedPairs, hostLabel) {
    if (!Array.isArray(resolvedPairs) || resolvedPairs.length === 0) {
      showNotice('No images to display', 3000);
      return;
    }

    let overlay = null;
    let closeBtn = null;
    let listenerController = null;

    try {
      const seenKeys = new Set();
      const deduplicatedPairs = resolvedPairs.filter(pair => {
        const key = pair.fullUrl || pair.thumbUrl || pair.pageUrl || pair.uniqueId || Math.random().toString();
        if (seenKeys.has(key)) return false;
        seenKeys.add(key);
        return true;
      });

      listenerController = new AbortController();
      const listenerSignal = listenerController.signal;

      overlay = document.createElement('div');
      overlay.className = 'vgt-overlay';

      const modal = document.createElement('div');
      modal.className = 'vgt-modal';

      const header = document.createElement('div');
      header.className = 'vgt-header';

      const title = document.createElement('div');
      title.className = 'vgt-title';
      const ok = deduplicatedPairs.filter(p => p.fullUrl).length;
      const fail = deduplicatedPairs.length - ok;
      title.textContent = hostLabel + ' Gallery — ' + ok + ' resolved' + (fail ? ' • ' + fail + ' failed' : '');

      closeBtn = document.createElement('button');
      closeBtn.className = 'resolver-btn-close';
      closeBtn.title = 'Close (Esc)';
      closeBtn.textContent = '✕';

      header.appendChild(title);
      modal.appendChild(header);

      const grid = document.createElement('div');
      grid.className = 'vgt-grid';

      deduplicatedPairs.forEach(pair => {
        const item = document.createElement('div');
        item.className = 'vgt-grid-item';

        const img = document.createElement('img');
        img.className = 'vgt-thumb';
        img.loading = 'lazy';
        img.alt = pair.uniqueId || '';
        img.src = pair.thumbUrl || pair.fullUrl || '';

        item.appendChild(img);

        const actions = document.createElement('div');
        actions.className = 'vgt-actions';

        if (pair.fullUrl) {
          img.style.cursor = 'pointer';
          img.addEventListener('click', (e) => {
            e.stopPropagation();
            if (pair.fullUrl && isSafeUrl(pair.fullUrl)) {
              const a = document.createElement('a');
              a.href = pair.fullUrl;
              a.target = '_blank';
              a.rel = 'noopener noreferrer';
              safeAppendToBody(a);
              a.click();
              a.remove();
            } else {
              showNotice('Invalid URL detected', 3000);
            }
          }, { signal: listenerSignal });

          const dl = document.createElement('button');
          dl.className = 'resolver-btn-download';
          dl.innerHTML = '<span class="dl-text">Download</span><span class="dl-icon">✓</span>';

          dl.addEventListener('click', (ev) => {
            ev.preventDefault();
            if (!pair.fullUrl || !isSafeUrl(pair.fullUrl)) {
              showNotice('Invalid URL', 3000);
              return;
            }
            dl.disabled = true;
            const textSpan = dl.querySelector('.dl-text');
            const iconSpan = dl.querySelector('.dl-icon');
            if (textSpan) textSpan.textContent = 'Downloading...';

            downloadWithRetry(pair.fullUrl, pair.pageUrl || pair.fullUrl, CONFIG.retryAttempts)
              .then(() => {
                dl.disabled = false;
                dl.classList.add('downloaded');
                if (textSpan) textSpan.style.opacity = '0';
                if (iconSpan) iconSpan.style.opacity = '1';
                dl.classList.add('success-pulse');
                setTimeout(function () {
                  try { dl.classList.remove('success-pulse'); } catch (e) {}
                }, 2000);
              })
              .catch(() => {
                dl.disabled = false;
                if (textSpan) {
                  textSpan.textContent = 'Download';
                  textSpan.style.opacity = '1';
                }
                if (iconSpan) iconSpan.style.opacity = '0';
                showNotice('Download failed', 3000);
              });
          }, { signal: listenerSignal });

          actions.appendChild(dl);
        } else {
          const f = document.createElement('button');
          f.className = 'resolver-btn-failed';
          f.textContent = 'Failed';
          f.disabled = true;
          actions.appendChild(f);
        }

        item.appendChild(actions);
        grid.appendChild(item);
      });

      modal.appendChild(grid);
      overlay.appendChild(modal);

      if (!safeAppendToBody(overlay)) {
        showNotice('Cannot display gallery', 3000);
        return;
      }
      safeAppendToBody(closeBtn);

      setTimeout(() => overlay.classList.add('open'), 10);

      function removeOverlay() {
        try {
          listenerController.abort();
          overlay.classList.remove('open');
          setTimeout(() => {
            try {
              if (overlay && overlay.parentNode) overlay.remove();
              if (closeBtn && closeBtn.parentNode) closeBtn.remove();
            } catch (e) { console.error('[Unified] overlay removal error:', e); }
          }, 200);
          activeGalleryCleanup = null;
        } catch (e) { console.error('[Unified] removeOverlay error:', e); }
      }

      function escapeHandler(e) {
        if (e.key === 'Escape') removeOverlay();
      }

      closeBtn.addEventListener('click', removeOverlay, { signal: listenerSignal });
      overlay.addEventListener('click', (e) => {
        if (e.target === overlay) removeOverlay();
      }, { signal: listenerSignal });
      document.addEventListener('keydown', escapeHandler, { signal: listenerSignal });

      activeGalleryCleanup = () => {
        try { listenerController.abort(); } catch (e) { console.error('[Unified] gallery abort error:', e); }
      };
        } catch (err) {
      try {
        if (listenerController) {
          try { listenerController.abort(); } catch (e) { console.error('[Unified] gallery abort error:', e); }
        }
        if (overlay && overlay.parentNode) overlay.remove();
        if (closeBtn && closeBtn.parentNode) closeBtn.remove();
        activeGalleryCleanup = null;
      } catch (e) { console.error('[Unified] gallery cleanup error:', e); }
      showNotice('Failed to open gallery: ' + (err.message || 'unknown error'), 5000);
    }
  }

      function addHostButtons(post) {
    try {
      if (post.querySelector('.vgt-container')) return;

     const hosts = [];

        try {
            const imxPairs = extractImxLinks(post);
            if (imxPairs.length > 0) {
                const dedupedImx = dedupePairsCanonical(imxPairs).map(p => ({
                    ...p,
                    resolveUrl: chooseResolveCandidate(p)
                }));
                if (dedupedImx.length > 0) {
                    hosts.push({
                        label: 'IMX',
                        pairs: dedupedImx,
                        count: dedupedImx.length,
                        resolver: resolveAllImx
                    });
                }
            }
        } catch (e) {
            console.error('[Unified] Failed to extract IMX links:', e);
        }

        try {
            const imvPairs = extractImagevenueLinks(post);
            if (imvPairs.length > 0) {
                const dedupedImv = dedupePairsCanonical(imvPairs);
                if (dedupedImv.length > 0) {
                    hosts.push({
                        label: 'ImV',
                        pairs: dedupedImv,
                        count: dedupedImv.length,
                        resolver: resolveAllImagevenue
                    });
                }
            }
        } catch (e) {
            console.error('[Unified] Failed to extract ImageVenue links:', e);
        }

        try {
            const iboxPairs = extractIboxLinks(post);
            if (iboxPairs.length > 0) {
                hosts.push({
                    label: 'BOX',
                    pairs: iboxPairs,
                    count: iboxPairs.length,
                    resolver: resolveAllIbox
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract ImgBox links:', e);
        }

        try {
            const viprPairs = extractViprLinks(post);
            if (viprPairs.length > 0) {
                hosts.push({
                    label: 'VPR',
                    pairs: viprPairs,
                    count: viprPairs.length,
                    resolver: resolveAllVipr
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract VIPR links:', e);
        }

        try {
            const ibamPairs = extractImagebamLinks(post);
            if (ibamPairs.length > 0) {
                hosts.push({
                    label: 'BAM',
                    pairs: ibamPairs,
                    count: ibamPairs.length,
                    resolver: resolveAllImagebam
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract ImageBam links:', e);
        }

        try {
            const turboPairs = extractTurboLinks(post);
            if (turboPairs.length > 0) {
                hosts.push({
                    label: 'TRB',
                    pairs: turboPairs,
                    count: turboPairs.length,
                    resolver: resolveAllTurbo
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract TurboImageHost links:', e);
        }

        try {
            const pixhostPairs = extractPixhostLinks(post);
            if (pixhostPairs.length > 0) {
                hosts.push({
                    label: 'PIX',
                    pairs: pixhostPairs,
                    count: pixhostPairs.length,
                    resolver: resolveAllPixhost
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract Pixhost links:', e);
        }

        try {
            const pimpRaw = extractPimpLinks(post);
            if (pimpRaw.length > 0) {
                const pimpMerged = dedupePmpPairsCanonical(pimpRaw);
                const pimpWithResolve = pimpMerged.map(p => ({ ...p, resolveUrl: choosePmpResolveCandidate(p) }));
                hosts.push({
                    label: 'PMP',
                    pairs: pimpWithResolve,
                    count: pimpWithResolve.length,
                    resolver: resolveAllPimp
                });
            }
        } catch (e) {
            console.error('[Unified] Failed to extract PimpAndHost links:', e);
        }

        if (hosts.length === 0) return;

      hosts.sort((a, b) => b.count - a.count);

      const controls = post.querySelector('span.nodecontrols');
      if (!controls) return;

      const postBody = post.closest('li.postbitlegacy') || post.parentElement;
      let progressWrap = postBody.querySelector('.vgt-progress');

      if (!progressWrap) {
        progressWrap = document.createElement('div');
        progressWrap.className = 'vgt-progress';

        const fileRow = document.createElement('div');
        fileRow.className = 'vgt-progress-row';
        const fileLabel = document.createElement('div');
        fileLabel.className = 'vgt-progress-label';
        fileLabel.textContent = 'File:';
        const fileBarContainer = document.createElement('div');
        fileBarContainer.className = 'vgt-progress-bar-container';
        const fileBar = document.createElement('div');
        fileBar.className = 'vgt-progress-bar-fill';
        fileBarContainer.appendChild(fileBar);
        const filePercentContainer = document.createElement('div');
        filePercentContainer.className = 'vgt-progress-percent-container';
        const filePercent = document.createElement('div');
        filePercent.className = 'vgt-progress-percent';
        filePercent.textContent = '0%';
        filePercentContainer.appendChild(filePercent);
        fileRow.appendChild(fileLabel);
        fileRow.appendChild(fileBarContainer);
        fileRow.appendChild(filePercentContainer);

        const totalRow = document.createElement('div');
        totalRow.className = 'vgt-progress-row';
        const totalLabel = document.createElement('div');
        totalLabel.className = 'vgt-progress-label';
        totalLabel.textContent = 'Total:';
        const totalBarContainer = document.createElement('div');
        totalBarContainer.className = 'vgt-progress-bar-container';
        const totalBar = document.createElement('div');
        totalBar.className = 'vgt-progress-bar-fill';
        totalBarContainer.appendChild(totalBar);
        const totalPercentContainer = document.createElement('div');
        totalPercentContainer.className = 'vgt-progress-percent-container';
        const totalPercent = document.createElement('div');
        totalPercent.className = 'vgt-progress-percent';
        totalPercent.textContent = '0%';
        totalPercentContainer.appendChild(totalPercent);
        totalRow.appendChild(totalLabel);
        totalRow.appendChild(totalBarContainer);
        totalRow.appendChild(totalPercentContainer);

        const footer = document.createElement('div');
        footer.className = 'vgt-progress-footer';
        const statusText = document.createElement('div');
        statusText.className = 'vgt-progress-status';
        statusText.textContent = '';
        const zipCancelBtn = document.createElement('button');
        zipCancelBtn.className = 'resolver-btn-cancel';
        zipCancelBtn.textContent = '✕';

        footer.appendChild(statusText);
        footer.appendChild(zipCancelBtn);

        progressWrap.appendChild(fileRow);
        progressWrap.appendChild(totalRow);
        progressWrap.appendChild(footer);

        controls.parentNode.insertBefore(progressWrap, controls.nextSibling);
      }

      const zipCancelBtn = progressWrap.querySelector('.vgt-progress-footer .resolver-btn-cancel');

      const hostButtons = [];
      const hostCancelButtons = [];

      const rawPostId = (post.id && post.id.trim() !== '')
        ? post.id
        : 'post_' + Date.now() + '_' + (++postIdCounter) + '_' + Math.random().toString(36).substr(2, 9);

      function disableAllHostButtons() {
        hostButtons.forEach(btn => {
          btn.disabled = true;
        });
      }

      function enableAllHostButtons() {
        hostButtons.forEach((btn, idx) => {
          btn.disabled = false;
          const hostInfo = hosts[idx];
          btn.innerHTML = hostInfo.label + ' (' + hostInfo.count + ') <span class="arrow">▼</span>';
        });
      }

      hosts.forEach((hostInfo, hostIndex) => {
        const postId = rawPostId + '_' + hostInfo.label;
        const idleLabel = hostInfo.label + ' (' + hostInfo.count + ')';

        const container = document.createElement('div');
        container.className = 'vgt-container';

        const mainBtn = document.createElement('button');
        mainBtn.className = 'resolver-btn resolver-btn-' + hostInfo.label.toLowerCase();
        mainBtn.innerHTML = idleLabel + ' <span class="arrow">▼</span>';
        mainBtn.title = hostInfo.label + ' Options — ' + hostInfo.count + ' images';

        hostButtons.push(mainBtn);

        const dropdown = document.createElement('div');
        dropdown.className = 'vgt-dropdown';

        const copyBtn = document.createElement('button');
        copyBtn.className = 'vgt-dropdown-item';
        copyBtn.innerHTML = `<svg class="icon-svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"/>
        <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"/>
        </svg> Copy URLs`;

        const galleryBtn = document.createElement('button');
        galleryBtn.className = 'vgt-dropdown-item';
        galleryBtn.innerHTML = `<svg class="icon-svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"/>
        <circle cx="12" cy="12" r="3"/>
        </svg> View Gallery`;

        const zipBtn = document.createElement('button');
        zipBtn.className = 'vgt-dropdown-item';
        zipBtn.innerHTML = `<svg class="icon-svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M21 8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16Z"/>
        <path d="m3.3 7 8.7 5 8.7-5"/>
        <path d="M12 22V12"/>
        </svg> Download ZIP`;

        const unzippedBtn = document.createElement('button');
        unzippedBtn.className = 'vgt-dropdown-item';
        unzippedBtn.innerHTML = `<svg class="icon-svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
        <polyline points="7 10 12 15 17 10"/>
          <line x1="12" x2="12" y1="15" y2="3"/>
        </svg> Download Images (PC)`;

        dropdown.appendChild(copyBtn);
        dropdown.appendChild(galleryBtn);
        dropdown.appendChild(zipBtn);
        dropdown.appendChild(unzippedBtn);

        container.appendChild(mainBtn);
        container.appendChild(dropdown);
        controls.appendChild(container);

        const galleryCancelBtn = document.createElement('button');
        galleryCancelBtn.className = 'resolver-btn-cancel';
        galleryCancelBtn.textContent = '✕';
        galleryCancelBtn.hidden = true;
        controls.appendChild(galleryCancelBtn);

        hostCancelButtons.push(galleryCancelBtn);

        mainBtn.addEventListener('click', function (e) {
          e.stopPropagation();
          if (this.disabled) return;

          const wasOpen = this.classList.contains('open');

          document.querySelectorAll('.vgt-dropdown.open').forEach(function (dd) {
            dd.classList.remove('open');
          });
          document.querySelectorAll('.resolver-btn.open').forEach(function (btn) {
            btn.classList.remove('open');
          });

          if (!wasOpen) {
            dropdown.classList.add('open');
            this.classList.add('open');
          }
        });

        copyBtn.addEventListener('click', async function () {
          dropdown.classList.remove('open');
          mainBtn.classList.remove('open');

          if (mainBtn.disabled) return;

          if (isPostProcessing(rawPostId)) {
            showNotice('Another operation in progress for this post', 2000);
            return;
          }

          const abortController = new AbortController();
          activeOperations.set(postId, {
            abortController: abortController,
            button: mainBtn,
            originalText: idleLabel
          });

          setPostProcessing(rawPostId, true);
          disableAllHostButtons();
          mainBtn.disabled = true;
          mainBtn.innerHTML = '<div class="spinner-resolving"><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span></div> Resolving';
          galleryCancelBtn.hidden = false;
          galleryCancelBtn.classList.add('active');

          try {
            const resolved = await hostInfo.resolver(
              hostInfo.pairs,
              function (current, total) {
                mainBtn.innerHTML = '<div class="spinner-resolving"><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span></div> Resolving ' + current + '/' + total;
              },
              abortController.signal
            );

            if (abortController.signal.aborted) {
              setPostProcessing(rawPostId, false);
              enableAllHostButtons();
              galleryCancelBtn.hidden = true;
              galleryCancelBtn.classList.remove('active');
              activeOperations.delete(postId);
              showNotice('Operation cancelled', 2000);
              return;
            }

            setPostProcessing(rawPostId, false);
            enableAllHostButtons();
            galleryCancelBtn.hidden = true;
            galleryCancelBtn.classList.remove('active');
            activeOperations.delete(postId);

            const successful = resolved.filter(function(r) { return r.fullUrl; }).map(function(r) { return r.fullUrl; });
            const failed = resolved.filter(function(r) { return !r.fullUrl; });

            if (successful.length === 0) {
              showNotice('All URLs failed to resolve', 3000);
              const failedUrls = failed.map(function(f) { return f.pageUrl || f.thumbUrl || 'Unknown URL'; });
              showErrorNotification('All ' + failed.length + ' link(s) failed to resolve', failedUrls);
              return;
            }

            const textToCopy = successful.join('\n');
            const copied = await copyToClipboard(textToCopy);

            if (!copied) return;

            if (failed.length > 0) {
              showNotice('✓ Copied ' + successful.length + '/' + resolved.length + ' URLs', 3000, true);
              const failedUrls = failed.map(function(f) { return f.pageUrl || f.thumbUrl || 'Unknown URL'; });
              showErrorNotification(failed.length + ' link(s) failed to resolve', failedUrls);
            } else {
              showNotice('✓ Copied ' + successful.length + ' URLs to clipboard', 3000, true);
            }

          } catch (err) {
            setPostProcessing(rawPostId, false);
            enableAllHostButtons();
            galleryCancelBtn.hidden = true;
            galleryCancelBtn.classList.remove('active');
            activeOperations.delete(postId);

            if (err && String(err.message || '').toLowerCase().indexOf('cancel') > -1) {
              showNotice('Operation cancelled', 2000);
            } else {
              showNotice('Resolve error: ' + (err && err.message || 'unknown'), 5000);
            }
          }
        });

        galleryBtn.addEventListener('click', async function () {
          dropdown.classList.remove('open');
          mainBtn.classList.remove('open');

          if (mainBtn.disabled) return;

          if (isPostProcessing(rawPostId)) {
            showNotice('Another operation in progress for this post', 2000);
            return;
          }

          const abortController = new AbortController();
          activeOperations.set(postId, {
            abortController: abortController,
            button: mainBtn,
            originalText: idleLabel
          });

          setPostProcessing(rawPostId, true);
          disableAllHostButtons();
          mainBtn.disabled = true;
          mainBtn.innerHTML = '<div class="spinner-resolving"><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span></div> Resolving';
          galleryCancelBtn.hidden = false;
          galleryCancelBtn.classList.add('active');

                    try {
            const resolved = await hostInfo.resolver(
              hostInfo.pairs,
              function (current, total) {
                mainBtn.innerHTML = '<div class="spinner-resolving"><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span><span></span></div> Resolving ' + current + '/' + total;
              },
              abortController.signal
            );

            if (abortController.signal.aborted) {
              setPostProcessing(rawPostId, false);
              enableAllHostButtons();
              galleryCancelBtn.hidden = true;
              galleryCancelBtn.classList.remove('active');
              activeOperations.delete(postId);
              showNotice('Operation cancelled', 2000);
              return;
            }

            setPostProcessing(rawPostId, false);
            enableAllHostButtons();
            galleryCancelBtn.hidden = true;
            galleryCancelBtn.classList.remove('active');
            activeOperations.delete(postId);
            openGallery(resolved, hostInfo.label);

          } catch (err) {
            setPostProcessing(rawPostId, false);
            enableAllHostButtons();
            galleryCancelBtn.hidden = true;
            galleryCancelBtn.classList.remove('active');
            activeOperations.delete(postId);

            if (err && String(err.message || '').toLowerCase().indexOf('cancel') > -1) {
              showNotice('Operation cancelled', 2000);
            } else {
              showNotice('Resolve error: ' + (err && err.message || 'unknown'), 5000);
            }
          }
        });

        galleryCancelBtn.addEventListener('click', function (ev) {
          ev.preventDefault();
          ev.stopPropagation();

          const op = activeOperations.get(postId);
          if (op && op.abortController) {
            try { op.abortController.abort(); } catch (e) { console.error('[Unified] abort error:', e); }
          }

          setPostProcessing(rawPostId, false);
          enableAllHostButtons();
          galleryCancelBtn.hidden = true;
          galleryCancelBtn.classList.remove('active');
          activeOperations.delete(postId);

          showNotice('Operation cancelled', 2000);
        });

                zipBtn.addEventListener('click', function () {
          dropdown.classList.remove('open');
          mainBtn.classList.remove('open');

          if (mainBtn.disabled) return;

          if (isPostProcessing(rawPostId)) {
            showNotice('Another operation in progress for this post', 2000);
            return;
          }

          setPostProcessing(rawPostId, true);
          disableAllHostButtons();

          downloadImages(
            hostInfo.pairs,
            postId,
            mainBtn,
            progressWrap,
            idleLabel,
            hostInfo.resolver,
            disableAllHostButtons,
            enableAllHostButtons,
            { zipped: true, postNumber: '0' }
          );
        });

                unzippedBtn.addEventListener('click', function () {
          dropdown.classList.remove('open');
          mainBtn.classList.remove('open');

          if (mainBtn.disabled) return;

          if (isPostProcessing(rawPostId)) {
            showNotice('Another operation in progress for this post', 2000);
            return;
          }

          setPostProcessing(rawPostId, true);
          disableAllHostButtons();

          const postNumber = extractPostNumber(post) || getPostIndex(post) || '0';

          downloadImages(
            hostInfo.pairs,
            postId,
            mainBtn,
            progressWrap,
            idleLabel,
            hostInfo.resolver,
            disableAllHostButtons,
            enableAllHostButtons,
            { zipped: false, postNumber: postNumber }
          );
        });

              });

        zipCancelBtn.addEventListener('click', function (ev) {
      ev.preventDefault();
      ev.stopPropagation();

      let activeOp = null;
      let activePostId = null;

      zipOperations.forEach(function (op, opPostId) {
        if (opPostId.indexOf(rawPostId) === 0) {
          activeOp = op;
          activePostId = opPostId;
        }
      });

      if (activeOp && activePostId) {
        cancelZipDownload(activePostId);
        setPostProcessing(rawPostId, false);
        enableAllHostButtons();
        resetZipUI(activeOp.mainBtn, activeOp.progressWrap, activeOp.idleLabel);
        activeOp.progressWrap.classList.remove('active');
        activeOperations.delete(activePostId);
        showNotice('Operation cancelled', 2000);
      } else {
        progressWrap.classList.remove('active');
        const status = progressWrap.querySelector('.vgt-progress-status');
        if (status) {
          status.innerHTML = '';
          status.className = 'vgt-progress-status';
        }
      }
    });

    } catch (e) {
      console.error('[Unified] addHostButtons error:', e);
      showNotice('Failed to add download buttons', 3000);
    }
  }

  function scan() {
    document.querySelectorAll('li.postbitlegacy').forEach(function (p) {
      try {
        if (!p.classList.contains('vgt-inited')) {
          p.classList.add('vgt-inited');
          addHostButtons(p);
        }
      } catch (e) { console.error('[Unified] scan error for post:', e); }
    });
  }

    function cleanup() {
    try {
      if (mutationObserver) { mutationObserver.disconnect(); mutationObserver = null; }
      if (bodyWaitObserver) { bodyWaitObserver.disconnect(); bodyWaitObserver = null; }
      if (cacheCleanupIntervalId) { clearInterval(cacheCleanupIntervalId); cacheCleanupIntervalId = null; }
      if (activeGalleryCleanup) { try { activeGalleryCleanup(); } catch (e) { console.error('[Unified] gallery cleanup error:', e); } activeGalleryCleanup = null; }
      if (activeScanTimeout) {
        clearTimeout(activeScanTimeout);
        activeScanTimeout = null;
      }
      if (currentErrorNotification) {
        try { currentErrorNotification.remove(); } catch (e) {}
        currentErrorNotification = null;
      }
      activeOperations.clear();
      resolutionCache.clear();
      zipOperations.clear();
    } catch (e) { console.error('[Unified] cleanup error:', e); }
  }

    function setupMainObserver() {
    if (mutationObserver) {
      mutationObserver.disconnect();
      mutationObserver = null;
    }

    mutationObserver = new MutationObserver(function () {
      try {
        if (activeScanTimeout) clearTimeout(activeScanTimeout);
        activeScanTimeout = setTimeout(function () {
          try {
            activeScanTimeout = null;
            scan();
          } catch (e) {
            console.error('[Unified] Scan error:', e);
          }
        }, 150);
      } catch (e) {
        console.error('[Unified] MutationObserver error:', e);
      }
    });
    mutationObserver.observe(document.body, { childList: true, subtree: true });

    setTimeout(function () {
      try { scan(); } catch (e) { console.error('[Unified] Initial scan error:', e); }
    }, 500);
  }

  function init() {
    injectStyles();
    insertTitleCopyButton();

    document.addEventListener('click', function (e) {
      if (!e.target.closest('.vgt-container')) {
        document.querySelectorAll('.vgt-dropdown.open').forEach(function (dd) {
          dd.classList.remove('open');
        });
        document.querySelectorAll('.resolver-btn.open').forEach(function (btn) {
          btn.classList.remove('open');
        });
      }
    });

    cacheCleanupIntervalId = setInterval(cleanExpiredCache, CONFIG.cacheCleanupInterval);
    scan();

    if (!document.body) {
      bodyWaitObserver = new MutationObserver(() => {
        if (document.body) {
          bodyWaitObserver.disconnect();
          bodyWaitObserver = null;
          setupMainObserver();
        }
      });
      bodyWaitObserver.observe(document.documentElement, { childList: true });
    } else {
      setupMainObserver();
    }

    window.addEventListener('beforeunload', function (e) {
      const hasActiveProcessing = Array.from(postProcessing.values()).some(v => v === true);
      if (hasActiveProcessing || zipOperations.size > 0) {
        const message = 'Downloads are in progress. Sure you want to exit?';
        e.returnValue = message;
        return message;
      }
    });

    window.addEventListener('unload', cleanup);
  }

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

})();